library(changepoint.np)
setwd("DIR/TO/CHICKEN_EXPRESSION_DATA")
conds <- c("blastoderm", "brain_E18", "brain_adult", "liver_E18", "liver_E19", "liver_adult", "kidney_E18", "kidney_adult",
           "bursa_E18", "heart_E18", "heart_E19", "heart_adult", "spleen_E18", "spleen_E19", "lung_E18","muscle_E18")

expr.df <- read.table("chicken.scaledLog2.wCoord.TPM", header = T) # First three columns -> gene coordinates (Chrom, Start, End); other columns -> samples; rows -> genes 
rownames(expr.df) <- expr.df$Gene
expr.df$Gene <- NULL
zGenes <- rownames(subset(expr.df, Chrom == "NC_006127.4"))

par(mfrow=c(4,4))
for (cond in conds){
  print(cond)
  ## Format (M-F) expression data 
  cond.df <- read.table(paste("chicken_cond/", cond, ".cond", sep=""), col.names = c("Sample", "Sex", "Type")) # each "XXX.cond" contains samples of a particular tissue/developmental stage; # (row -> sample; 1st column -> sample name; 2nd column -> sex; 3rd column is not necessary in this program)
  samples <- as.character(cond.df$Sample)
  maleSamples <- as.character(cond.df[cond.df$Sex == "Male",]$Sample)
  femaleSamples <- as.character(cond.df[cond.df$Sex == "Female",]$Sample)
  
  maleExpr.df <- expr.df[zGenes, maleSamples]
  femaleExpr.df <- expr.df[zGenes, femaleSamples]
  chickenMaleExprAvg <- apply(maleExpr.df, 1, mean)
  chickenFemaleExprAvg <- apply(femaleExpr.df, 1, mean)
  coord <- subset(expr.df, Chrom == "NC_006127.4")[,c("Start", "End"), drop=F]
  
  expr.Z.df <- cbind(coord, chickenMaleExprAvg, chickenFemaleExprAvg)
  expr.Z.ordered.df <- subset(expr.Z.df[with(expr.Z.df, order(Start)),], chickenMaleExprAvg > 1 | chickenFemaleExprAvg > 1)

  data <- expr.Z.ordered.df$chickenMaleExprAvg - expr.Z.ordered.df$chickenFemaleExprAvg
  
  ## Changepoint analysis
  cpt.out <- cpt.np(data, nquantiles = 10)
  cpts <- as.numeric(cpt.out@cpts)
  plot(cpt.out, main=cond)
  print(expr.Z.ordered.df[cpts,]$Start)
  print(expr.Z.ordered.df[cpts,]$End)
}
