#This file is used to make a .fa file from the list of barcodes I generated from
#the barcoder sequencing data. It begins with a .csv file of all the putative barcodes
#that i've identified. I will first use it on the glucose barcoder comeptition.
#
#
#
#

import sys
import argparse
import numpy as np
from scipy.stats import ttest_ind
import os
import random
from Bio.Seq import Seq

parser = argparse.ArgumentParser()
parser.add_argument("-barcodes", default=None, dest="barcodes")
parser.add_argument("-output_filename", default=None, dest="output")
args = parser.parse_args()

barcode_filehandle=open(args.barcodes, "r")
barcode_filestring=barcode_filehandle.read()
barcode_splitfilestring=barcode_filestring.split("\r")

outputfilename = str(os.getcwd()) + "/" + str(args.output)
output_file = open(outputfilename, "w")

new_filelist=[]
counter = 0
for entry in barcode_splitfilestring:
	new_entry = []
	counter = counter+1
	new_entry.append(">Barcoder_" + str(counter))
	new_entry.append(entry)
	new_filelist.append(new_entry)
	
for line in new_filelist:
	output_file.write(line[0])
	output_file.write("\r\n")
	output_file.write(line[1])
	output_file.write("\r\n")
