# # Run the script "PDE efficiency across temperature" before executing this script
# ------------ stacked bar chart --------------
library("stringr")
# Prep experimental data frame (sort tabs and bind)
smart18 <- read.table(' path to sMART18.txt ', h = T, sep = '\t')
df18 <- cbind(SIGN18_dist[order(SIGN18_dist$IES_ID),], smart18[order(smart18$IES_ID1),])
df18$Temp <- "18°C"

smart25 <- read.table(' path to sMART25.txt ', h = T, sep = '\t')
df25 <- cbind(SIGN25_dist[order(SIGN25_dist$IES_ID),], smart25[order(smart25$IES_ID1),])
df25$Temp <- "25°C"

smart32 <- read.table(' path to sMART32.txt ', h = T, sep = '\t')
df32 <- cbind(SIGN32_dist[order(SIGN32_dist$IES_ID),], smart32[order(smart32$IES_ID1),])
df32$Temp <- "32°C"

df <- rbind(df18[, 22:25], df25[, 22:25], df32[, 22:25])
test <- df
test$JOIN <- paste(test$Sign_DCL2.3, test$Sign_DCL5, sep = "")
test$DCL <- str_replace(test$JOIN, "ff", "Dcl2/3- | Dcl5-")
test$DCL <- str_replace(test$DCL, "ft", "Dcl2/3- | Dcl5+")
test$DCL <- str_replace(test$DCL, "tt", "Dcl2/3+ | Dcl5+")
test$DCL <- str_replace(test$DCL, "tf", "Dcl2/3+ | Dcl5-")

# Prep mock dataframe
smart_PGM <- read.table(' path to sMART_KD_PGM.txt ', h = T, sep = '\t')
smart_PGM$JOIN <- paste(smart_PGM$Sign_DCL2.3, smart_PGM$Sign_DCL5, sep = "")
smart_PGM$DCL <- str_replace(smart_PGM$JOIN, "ff", "Dcl2/3- | Dcl5-")
smart_PGM$DCL <- str_replace(smart_PGM$DCL, "ft", "Dcl2/3- | Dcl5+")
smart_PGM$DCL <- str_replace(smart_PGM$DCL, "tt", "Dcl2/3+ | Dcl5+")
smart_PGM$DCL <- str_replace(smart_PGM$DCL, "tf", "Dcl2/3+ | Dcl5-")


Rando_18 <- sample(smart_PGM$IES_ID1, length(test$IES_ID1[test$Temp=="18°C"]))
Rando_18_df <- smart_PGM[which(smart_PGM$IES_ID1%in%Rando_18),]
Rando_18_df$Temp <- "18°C"

Rando_25 <- sample(smart_PGM$IES_ID1, length(test$IES_ID1[test$Temp=="25°C"]))
Rando_25_df <- smart_PGM[which(smart_PGM$IES_ID1%in%Rando_25),]
Rando_25_df$Temp <- "25°C"

Rando_32 <- sample(smart_PGM$IES_ID1, length(test$IES_ID1[test$Temp=="32°C"]))
Rando_32_df <- smart_PGM[which(smart_PGM$IES_ID1%in%Rando_32),]
Rando_32_df$Temp <- "32°C"

df_rando <- rbind(Rando_18_df, Rando_25_df, Rando_32_df)

# Prep combo df
test$SET <- 1
df_rando$SET <- -1

combo_df2 <- rbind(df_rando, test)

## plot a back to back bar chart
# X Axis Breaks and Labels 
brks <- seq(-350, 350, 50)
lbls = as.character(c(seq(350, 0, -50), seq(50, 350, 50)))

ggplot(combo_df2, aes(x = Temp, y = SET, fill = DCL)) +   # Fill column
  geom_bar(stat = "identity", width = 0.85) +   # draw the bars
  scale_y_continuous(breaks = brks,   # Breaks
                     labels = lbls) + # Labels
  coord_flip() +  # Flip axes
  labs(title="", 
       subtitle="", 
       caption="") +
  theme_tufte() +  # Tufte theme from ggthemes
  theme(axis.title.x = element_blank(),
        axis.title.y = element_blank(),
        plot.title = element_text(hjust = .5), 
        axis.ticks = element_blank(), axis.text=element_text(size=30), axis.title=element_text(size=20),legend.text=element_text(size=15)) +   # Centre plot title
  scale_fill_brewer(palette = "Dark2") + # Color palette
  geom_line(aes(0, 0)) + geom_hline(yintercept=0, linetype="dashed", color = "black", size=1) #+
#geom_label(x=2, y=150, label="Observed", col = "black", size = 5) #+
#geom_label(x=2, y=-150, label="Expected", col = "black", size = 5)



