#!/usr/bin/env python
# coding: utf-8

# In[2]:


import pandas as pd
import seaborn as sns
import numpy as np
from matplotlib import pyplot as plt
#get_ipython().run_line_magic('matplotlib', 'inline')


# In[3]:


plt.rcParams["font.family"] = "Arial"


# In[4]:


ohno_ies = pd.read_excel("/path/to/Supplemental_Table_S5.xlsx", sep = '\t')


# In[5]:


steps = np.arange(0, 0.11, 0.01)


# In[6]:


pairs = []
ohno_wo_ies = []
ohno_with_ies = []

for s in steps:
    pairs.append(len(ohno_ies[(ohno_ies.WGD1_IRS_25F0 == 0) & (ohno_ies.IRS_25F0 > s)].GENE_ID.drop_duplicates()))
    ohno_with_ies.append(ohno_ies[(ohno_ies.WGD1_IRS_25F0 == 0) & (ohno_ies.IRS_25F0 > s)][['GENE_ID', 'TPM_AVG_25']].drop_duplicates().TPM_AVG_25.mean())
    ohno_wo_ies.append(ohno_ies[(ohno_ies.WGD1_IRS_25F0 == 0) & (ohno_ies.IRS_25F0 > s)][['GENE_ID', 'WGD1_TPM_AVG_25']].drop_duplicates().WGD1_TPM_AVG_25.mean())


# In[7]:


x = steps * 100
fig, ax = plt.subplots(figsize = (20,10))
ax.bar(x, height = ohno_with_ies, width = 0.4, color = 'black', label = 'Genes with IRS>0')
ax.bar(x + 0.4, height = ohno_wo_ies, width = 0.4, facecolor = 'lightgrey', edgecolor = 'black', linewidth = 0.5, label = 'Most recent ohnologs with IRS=0')
ax.set_xticks(x + 0.2, )
ax.set_xticklabels(['>0 vs 0', '>0.01 vs 0', '>0.02 vs 0', '>0.03 vs 0', '>0.04 vs 0',
                    '>0.05 vs 0', '>0.06 vs 0', '>0.07 vs 0', '>0.08 vs 0', '>0.09 vs 0', '>0.1 vs 0'], fontsize = '14')
ax.spines['bottom'].set_visible(False)
ax.spines['top'].set_visible(False)
ax.spines['right'].set_visible(False)
ax.set_ylim((0,15))
ax.legend(loc = 'upper center', fontsize = '16', frameon = False)
ax.tick_params(direction='out', length=0, width=2, colors='black', axis = 'x',
               grid_color='black', grid_alpha=0.5, pad = 15)
ax.set_yticks([0,5,10,15])
ax.set_yticklabels(ax.get_yticks(),fontsize = '14')
ax.set_ylabel('Expression level (TPM)', fontsize = '16', fontweight = 'bold')
ax.set_xlabel('IRS', fontsize = '16', fontweight = 'bold')
sigs = ['ns','ns','*', '**', '**', '*', '*', '**', '**', '**', '**']
for i, v in enumerate(ohno_wo_ies):
    ax.text(i + 0.2, v + 0.4, '(' + str(pairs[i]) + ')', color='black', fontsize=14, horizontalalignment = 'center')
for i, v in enumerate(ohno_wo_ies):
    ax.text(i + 0.2, v + 0.9, str(sigs[i]), color='darkred', fontsize=14, horizontalalignment = 'center', fontweight = 'bold')
plt.savefig("/path/to/save/Fig6.tiff", bbox_inches = 'tight', dpi = 600)






