#!/usr/bin/perl -w
use Cwd;
use strict;

my $dir = getcwd;

my $path = "$dir/res/duprm/ReadClass/methratio";
chdir $path;

my @files = glob("*_chrM.duprm_Remain.txt");
system("mkdir wig");
foreach my $file (@files) {
  print "processing...\t$file\n";
  my ($spname) = split/_chrM.duprm_Remain.txt/,$file;
  WIGcreate($path,$file,$spname,"chrM");
}

sub WIGcreate {
    my $path = shift;
    my $file = shift;
    my $spname = shift;
    my $refname = shift;

    chdir $path;
    open F, $file || "$!";
    <F>;

    my $trackH = "track type=wiggle_0 name=H-${spname} description=H-${spname} visibility=full graphType=bar autoScale=on viewLimits=0.0:1 color=50,100,255 yLineMark=11.76 yLineOnOff=on priority=10 windowingFunction=mean smoothingWindow=off\nvariableStep chrom=$refname\n";
    my $trackL = "track type=wiggle_0 name=L-${spname} description=L-${spname} visibility=full graphType=bar autoScale=on viewLimits=0.0:1 color=50,100,255 yLineMark=11.76 yLineOnOff=on priority=10 windowingFunction=mean smoothingWindow=off\nvariableStep chrom=$refname\n";

    open HME, ">./wig/H-${spname}-me.wig" || "$!";
    open LME, ">./wig/L-${spname}-me.wig" || "$!";
    open HCOV, ">./wig/H-${spname}-cov.wig" || "$!";
    open LCOV, ">./wig/L-${spname}-cov.wig" || "$!";

    print HME $trackH;
    print LME $trackL;
    print HCOV $trackH;
    print LCOV $trackL;

    while (<F>) {
        chomp;
        my @line = split/\t/,$_;
        my $ratio = $line[4];
        my $cov = $line[7];
        my $strand = $line[2];
        my $pos = $line[1];

        if ($cov >= 10) {
            if ($strand eq "+") {
                print LME join("\t",$pos,$ratio),"\n";
            }
            if ($strand eq "-") {
                print HME join("\t",$pos,$ratio),"\n";
            }
        }

        if ($strand eq "+") {
            print LCOV join("\t",$pos,$cov),"\n";
        }
        if ($strand eq "-") {
            print HCOV join("\t",$pos,$cov),"\n";
        }
    }

}
