#!/usr/bin/perl -w
use Cwd;
use strict;

my $dir = getcwd;

my $reffa = "$dir/data/chrM_mm10.fa";
open REFFA, $reffa || "$!";
<REFFA>;
my @refseq;
while (<REFFA>) {
    chomp;
    my $temp = uc($_);
    my @line = split//,$temp;
    push @refseq, @line;
}

chdir "$dir/res/duprm";
my @sams = glob("*_chrM.duprm.sam");
print join("\n",@sams),"\n";

map {readReclass($_, "$dir/res/duprm/")} @sams;


sub readReclass {
  my $sam = shift;
  my $path = shift;
  chdir $path;
  my $outpath = "$dir/res/duprm/ReadClass";
  if (!(-e $outpath)) {
    system("mkdir $outpath");
  }
  open F, $sam || "$!";
  my ($sp) = split/.sam/,$sam;
  open OUT, ">$outpath/${sp}_Remain.sam" || "$!";
  #open MIS, ">$outpath/${sp}_Mismatch.sam" || "$!";
  #open CHANGE, ">$outpath/${sp}_StrandChange.sam" || "$!";
  #open EQUAL, ">$outpath/${sp}_EqualChance.sam" || "$!";

  FLAG: while (<F>) {
    chomp;
    if ($_ =~ /^@/) {
        print OUT $_,"\n";
        #print MIS $_,"\n";
        #print CHANGE $_,"\n";
        #print EQUAL $_,"\n";
        next FLAG;
    }
    my @line = split/\t/,$_;
    my $start = $line[3];
    my ($length) = split/M/,$line[5];
    my $end = $start + $length -1;

    my $seq = uc($line[9]);
    my @seq = split//,$seq;
    my @realseq = @refseq[($start-1)..($end-1)];

    my ($black1, $four) = split/ZS:Z:/,$line[12];

    if ($#seq == $#realseq) {
      my $forward = 0;
      my $reverse = 0;
      my $mismatch = 0;
      foreach my $seqi (0..$#seq) {
        my $seqb = $seq[$seqi];
        my $realb = $realseq[$seqi];
        if ($seqb ne $realb) {
          if ($realb eq "C") {
            if ($seqb eq "T") {
              $forward++;
            }
            else {
              $mismatch++;
            }
          }
          elsif ($realb eq "G") {
            if ($seqb eq "A") {
              $reverse++;
            }
            else {
              $mismatch++;
            }
          }
          else {
            $mismatch++;
          }
        }
      }
      if (($forward == 0) && ($reverse == 0)) {
        #print MIS $_,"\n";
        next FLAG;
      }
      elsif ($forward > $reverse) {
        if (($four eq "++") || ($four eq "+-")) {
          print OUT $_,"\n";
        }
        elsif ($four eq "--") {
          print OUT join("\t",@line[0..11],"ZS:Z:++"),"\n";
          #print CHANGE join("\t",@line[0..11],"ZS:Z:++"),"\n";
        }
        elsif ($four eq "-+") {
          print OUT join("\t",@line[0..11],"ZS:Z:+-"),"\n";
          #print CHANGE join("\t",@line[0..11],"ZS:Z:+-"),"\n";
        }
      }
      elsif ($forward < $reverse) {
        if (($four eq "--") || ($four eq "-+")) {
          print OUT $_,"\n";
        }
        elsif ($four eq "++") {
          print OUT join("\t",@line[0..11],"ZS:Z:--"),"\n";
          #print CHANGE join("\t",@line[0..11],"ZS:Z:--"),"\n";
        }
        elsif ($four eq "+-") {
          print OUT join("\t",@line[0..11],"ZS:Z:-+"),"\n";
          #print CHANGE join("\t",@line[0..11],"ZS:Z:-+"),"\n";
        }
      }
      elsif ($forward == $reverse) {
        #print EQUAL $_,"\n";
        next FLAG;
      }
      else {
        print "No way!\n";
      }
    }
    else {
      print "No equal length!\n";
    }
  }
}
