#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import sys
import numpy as np

def error(string, error_type=1):
    sys.stderr.write('ERROR: ' + string + '\n')
    exit(error_type)

def log(string):
    sys.stderr.write('LOG: ' + string + '\n')

#####

for file in sys.argv[1:]:

    read_names = []
    read_lengths = []

    if file.endswith('.sam'):

        with open(file) as fh:

            for line in fh:
                if line.startswith('@'):
                    continue
                lt = line.strip().split('\t')
                read_name = lt[0]
                if read_name in read_names:
                    continue
                read_lengths.append(int(len(lt[9])))

    else:
        # assume fastq
        with open(file) as fh:

            for line in fh:

                l4 = [line.strip(), fh.readline().strip(), fh.readline().strip(), fh.readline().strip()]
                read_name = l4[0].split()[0][1:]
                if read_name in read_names:
                    error(f'Duplicate read names in {file}')
                read_lengths.append(int(len(l4[1])))

    maxlen = max(read_lengths)
    median = np.median(read_lengths)

    print(f'\n--- Stats for: {file} ---')
    print(f'Num reads:\t{len(read_lengths)}')
    print(f'Max len:\t{maxlen}')
    print(f'Median len:\t{median}')
