from Bio import SeqIO
from collections import defaultdict
import re
cnt = 0
dic_sORF = defaultdict(dict)
def readFastaToDic(fastaFile,genomicSequence, outFileBed):
    for seq in SeqIO.parse(fastaFile, "fasta"):
        sp = seq.id.split("#")
        strand = sp[2]
        if strand == "+":
            seq_sORF_for_search = str(seq.seq)
        else:
            seq_sORF_for_search = str(seq.reverse_complement().seq)
        chrom = sp[0]
        dic_sORF[chrom][seq.id] = seq_sORF_for_search
    print("Dictionary created")
    parseGenome(genomicSequence, outFileBed)


def parseGenome(genomicSequence, outFileBed):
    t = 0
    global cnt
    with open(outFileBed, "w") as out:
        for seq in SeqIO.parse(genomicSequence, "fasta"):
            if seq.id in dic_sORF:
                for sORFs in dic_sORF[seq.id]:
                    p = re.search(dic_sORF[seq.id][sORFs], str(seq.seq))
                    i = sORFs
                    if (p):
                        t+=1
                        out.write(i.split("#")[0] + "\t" + str(p.start()) + "\t" +
                                  str(p.end()) + "\t" + i.split("#")[2] + "\t" + i.split("#")[3] + "\t" + i +"\n")
                        if t%1000 == 0:
                            print(t)
                    else:
                        cnt+=1
    print(cnt)





if __name__ == '__main__':
    import argparse
    parser = argparse.ArgumentParser(description = 'Parse sORFfinder output file to generate bed file')
    parser.add_argument("infile", help='name of sORF fasta file generated by sORFfinder')
    parser.add_argument("genomFile", help='name of target genome fasta file used for sORFfinder')
    parser.add_argument("outputfileName", help='number of threads',default=4)
    args = parser.parse_args()
    readFastaToDic(args.infile,args.genomFile, args.outputfileName)

