% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimPeaks.R
\name{trimPeaks}
\alias{trimPeaks}
\title{Trim peaks}
\usage{
trimPeaks(se, cutoffPvalue = 0.05, backgroundPercentage = 0.25,
  countFilter = 1000, ratioAssay = "ratio",
  backgroundCorrectedAssay = "bcRatio",
  smoothedRatioAssay = "smoothedRatio", zscoreAssay = "zscore")
}
\arguments{
\item{se}{An object of 
\link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment}
with assays of raw counts, ratios, background corrected ratios,
smoothed ratios and z-scores. It should be an element of the output of 
\link{smoothRatiosByChromosome}}

\item{cutoffPvalue}{numeric(1). Cutoff p-value.}

\item{backgroundPercentage}{numeric(1). Cutoff value for the peaks height.}

\item{countFilter}{numeric(1) or integer(1). Cutoff value for mean of 
raw reads count in each window.}

\item{ratioAssay}{character(1). The name of assay in se, which store the 
values to be smoothed.}

\item{backgroundCorrectedAssay, smoothedRatioAssay, zscoreAssay}{Assays names 
for background-corrected ratios, smoothed ratios and z-scores based on
background corrected ratios.}
}
\value{
An object of \link[GenomicRanges:GRanges-class]{GRanges}.
}
\description{
Filter the peaks by pvalue and trim the range of peaks 
for an NAD experiment without biological replicates.
}
\examples{

data(single.count)
se <- single.count
dat <- log2se(se, nucleolusCols="N18.subsampled.srt.bam", genomeCols="G18.subsampled.srt.bam", 
transformation="log2CPMRatio")
## Smooth the ratios for each chromosome.
dat <- smoothRatiosByChromosome(dat, N=100, chr=c("chr18","chr19"))
peaks <- trimPeaks(dat[["chr18"]],
                backgroundPercentage=.25,
                cutoffPvalue=0.05, countFilter=1000)

}
