% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakdet.R
\name{peakdet}
\alias{peakdet}
\title{Detect peak positions}
\usage{
peakdet(y, delta = 0, silence = TRUE)
}
\arguments{
\item{y}{A numeric vector for searching peaks}

\item{delta}{A numeric vector of length 1, defining the minimum absolute changes required
for local maximum or minimum detection when slope sign changes. If it is set to 0, 
the delta will be set to 1/10 of the range of y.}

\item{silence}{logical(1). 
If false, echo the delta value when delta is set as 0.}
}
\value{
A list with peakpos and valleypos. Both peakpos and valleypos are
numeric vectors storing the positions of peaks or valleys.
}
\description{
Detect the peak positions and valley positions leveraging
github::dgromer/peakdet
}
\examples{
y <- runif(200)
peakdet(y)
y <- sin(seq(0,20))
peakdet(y)
}
