% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callPeaks.R
\name{callPeaks}
\alias{callPeaks}
\title{Call peaks using transformed, background corrected, and smoothed ratios with biological replicates}
\usage{
callPeaks(se, backgroundCorrectedAssay = "bcRatio",
  normalization.method = "quantile", N = 100,
  cutoffAdjPvalue = 1e-04, countFilter = 1000,
  combineP.method = "minimump", smooth.method = "loess",
  lfc = log2(1.5), ...)
}
\arguments{
\item{se}{An object of
\link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment}
with assays of raw counts, tranformed ratios, background corrected ratios,
smoothed ratios and z-scores. It should be an element of output of
\link{smoothRatiosByChromosome}}

\item{backgroundCorrectedAssay}{character(1). Assays names
for background corrected log2-transformed ratios, CPMRatios or OddRatios.}

\item{normalization.method}{character(1) specifying the normalization
method to be used. Choices  are "none", "scale", "quantile" or "cyclicloess".
See \link[limma]{normalizeBetweenArrays} for details.}

\item{N}{numeric(1) or integer(1).
The number of  neighboring windows used for loess smoothing or the inverse of
the critical frequencies of the low pass filter for butterworth filter.
1/N is a cutoff at 1/N-th of the Nyquist frequency.
Default 100.}

\item{cutoffAdjPvalue}{numeric(1). Cutoff adjust p-value.}

\item{countFilter}{numeric(1). Cutoff value for mean of raw reads count
in each window.}

\item{combineP.method}{A method used to combine P-values. Default minimump}

\item{smooth.method}{A method used to smooth the ratios. Choices are "loess",
"none" and "butterworthfilter".}

\item{lfc}{the minimum log2-fold-change that is considered scientifically meaningful}

\item{...}{Parameter not used.}
}
\value{
An object of GRanges of peak list with metadata "AveSig", "P.Value",
and "adj.P.Val", where "AveSig" means average signal such as average log2OddsRatio, log2CPMRatio or log2Ratio.
}
\description{
Use limma to calculate p-values for NADs
}
\details{
By default, use the mean smoothed ratio for each peak region to calculate p-values
}
\examples{

data(triplicate.count)
se <- triplicate.count
se <- log2se(se, transformation = "log2CPMRatio",
             nucleolusCols = c("N18.subsampled.srt-2.bam",
             "N18.subsampled.srt-3.bam",
             "N18.subsampled.srt.bam"),
             genomeCols = c("G18.subsampled.srt-2.bam",
             "G18.subsampled.srt-3.bam",
             "G18.subsampled.srt.bam"))
se<- smoothRatiosByChromosome(se, chr="chr18")
#add some variability to the data since the triplicate.count data was created using one sample only
assays(se[[1]])$bcRatio[,2] <- assays(se[[1]])$bcRatio[,2] + 0.3
assays(se[[1]])$bcRatio[,3] <- assays(se[[1]])$bcRatio[,3] - 0.3
peaks <- callPeaks(se[[1]],
                cutoffAdjPvalue=0.001, countFilter=10)

}
\author{
Jianhong Ou, Haibo Liu and Julie Zhu
}
