% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backgroundCorrection.R
\name{backgroundCorrection}
\alias{backgroundCorrection}
\title{Correct ratios for background}
\usage{
backgroundCorrection(ratios, degree = 3, ...)
}
\arguments{
\item{ratios}{A vector of numeric. It is log2-transformed ratios, CPMRatios 
or OddRatios of counts for each window.}

\item{degree}{Degree of polynomial. default 3.}

\item{...}{parameters could be passed to
\link[baseline]{baseline.modpolyfit}.}
}
\value{
A vector of numeric.
It is the background corrected log2-transformed ratios, CPMRatios or OddRatios.
}
\description{
Correct ratios of read counts per sliding window for background.
}
\details{
This function implements the backgound correction methods of
algorithm for polynomial fitting. See details via
\code{\link[baseline]{baseline.modpolyfit}}. This function expects 
the trendency of decreasing of the ratios from 5' end to 3' end.
}
\examples{
x <- runif(200)
background <- rep(c(20:1)/100, each=10)
backgroundCorrection(x)

}
