use lib "$ENV{FIREDIR}/SCRIPTS";

use Sets;
use Table;
use strict;

my $outtag	= Sets::get_parameter(\@ARGV, "-outtag");

my $CVx	= 3;
if (Sets::exist_parameter(\@ARGV, "-crossval") == 1) 
	{
	$CVx	= Sets::get_parameter(\@ARGV, "-crossval");
	}

my $crossvaldir	= "";
if (Sets::exist_parameter(\@ARGV, "-crossvaldir") == 1) 
	{
	$crossvaldir	= Sets::get_parameter(\@ARGV, "-crossvaldir");
	}

my $dnarnaDIR	= "DNA/";
if (Sets::exist_parameter(\@ARGV, "-dnarnaDIR") == 1) 
	{
	$dnarnaDIR	= Sets::get_parameter(\@ARGV, "-dnarnaDIR");
	}

#$summaryfileList = "$p->{crossvaldir}\/\*.tra\/\*NA\/\*.summary";
#my $summary_files = Sets::getFiles($summaryfileList);


for (my $ix=0; $ix<$CVx; $ix++) 
	{

	my $cvtag     = $outtag . ".CV" . $ix;
	my $cvtag_tra = $cvtag . ".tra";

	my $motfile  = $crossvaldir . "/" . $cvtag . ".motifs";
	my $sumfile  = $crossvaldir . "/" . $cvtag_tra . "_FIRE\/" . $dnarnaDIR  . $cvtag_tra . ".summary";

	if (-e $sumfile)
		{
		my $ta = Table->new;
		$ta->loadFile($sumfile);
		my $a_ref_mo = $ta->getArray();
		my %STAT      = ();
		my @MOTIFS    = ();
		if(scalar(@$a_ref_mo)>0)
		{
		open (OUT, ">". $motfile) || die "Can't open " . $motfile;
		foreach my $r (@$a_ref_mo) 
			{
			push @MOTIFS, $r->[0];
			print OUT $r->[0] . "\n";
			}
		close OUT;
		}
		}
	}


