
package Routines_GetCmds;
use base 'Exporter';
our @EXPORT = qw(generate_files get_cmd_removedups);


sub get_cmd_createcrossval 
{
	my ($p) = @_;

	my $fireprog  = "fire.pl";
	if (defined($p->{mbins}))
		{
		$fireprog  = "fire_mbins.pl";
		}
	if (defined($p->{maxdegeneracy}) && (!defined($p->{mbins})))
		{
		$fireprog  = "fire_maxdeg.pl";
		}
	if (defined($p->{maxdegeneracy}) && (defined($p->{mbins})))
		{
		$fireprog  = "fire_mbins_maxdeg.pl";
		}
	
	my $dnarnatag ="";
	if (defined($p->{fordna}))
		{
			if($p->{fordna}==1)
			{
			$dnarnatag = "DNA";
			}
		elsif ( (defined($p->{forrna})) && ($p->{forrna}==1) )
			{
			$dnarnatag = "RNA";
			}
		}
	my $todo = "";

	###############################################
	# Write Cross Validation test and training sets
	###############################################
	$todo .= "echo \"$dnarnatag, Step 0.1: create cross validation sets.\"";

	$todo .= "\nperl $p->{scriptdir}/create_cross_validation_sets.pl -quantfile $p->{quantfile} -expfile $p->{expfile} -outtag $p->{outtag} -crossval $p->{crossval} -crossvaldir $p->{crossvaldir} ";
	if ( defined( $p->{quantized} ) ) 
		{
		$todo .= " -quantized $p->{quantized} ";
		}
	if ( defined( $p->{seed} ) ) 
		{
		$todo .= " -seed $p->{seed} ";
		}
	if ( defined( $p->{ebins} ) ) 
		{
		$todo .= " -ebins $p->{ebins} ";
		}
	if ( defined($p->{quantized}) && ($p->{quantized}==0) ) 
		{
		$todo .= "\ncp $p->{expfile} $p->{expfile}\.nonquantized ";
		$todo .= "\ncp $p->{quantfile} $p->{expfile} ";
		}

	###############################################
	# Run fire on training sets
	###############################################

	my $relevantArgs 	= "";	# args that should be passed on every fire run (species files etc)
	my $trainingonlyArgs 	= "";	# args that shouldnt be there when running nondicovery (minr, j_nt)
	my $mergeonlyArgs 	= "";	# args for shuffling parameters, not relevant for testing set, but included for final non-disc run
	my $irrelevantArgs 	= "";	# args that force fire to stop right after generating .sumarry file so that we don't waste comp time
	my $dnarnaDIR 		= "";   
	my $minrarg		= "--minr=5";

	if ( defined( $p->{cmdline_args} ) ) 
		{
		my @argArray = split(/\t/, $p->{cmdline_args});
		for (my $ix=0; $ix<@argArray; $ix++)
			{
			my $arg = $argArray[$ix];
			if ( ($arg !~ m/^\-+expfile/) && ($arg !~ m/^\-+exptype/) && ($arg !~ m/^\-+ebins/) && ($arg !~ m/^\-+crossval/) 
				&& ($arg !~ m/^\-+dodna/) && ($arg !~ m/^\-+dorna/) && ($arg !~ m/^\-+submit/) )
				{
				if  ($arg =~ m/^\-+minr/)
					{
					$trainingonlyArgs .= " $arg";
					$mergeonlyArgs .= " $arg";
					$minrarg = "$arg"; $minrarg =~ s/\=/\ /; $minrarg =~ s/--/-/; 
					}
				elsif ($arg =~ m/^\-+j_nt/)
					{
					# $trainingonlyArgs .= " $arg";
					$mergeonlyArgs .= " $arg";
					}
				elsif ( ($arg =~ m/^\-+shuffle/) )
					{
					$trainingonlyArgs .= " $arg";
					$mergeonlyArgs .= " $arg";
					}
				else
					{
					$relevantArgs .= " $arg";
					}
				}

			}
		}
	$relevantArgs .= " --exptype=discrete --crossval=0 --submit=0 --nodups=1 ";
	if ( defined($p->{fordna}) ) 
		{
		if($p->{fordna}==1)
			{
			$relevantArgs .= " --dodna=1 --dorna=0 --dodnarna=0 ";
			$dnarnaDIR = "DNA/";
			$irrelevantArgs .= " --domidist=0"
			}
		elsif ( (defined($p->{forrna})) && ($p->{forrna}==1) )
			{
			$relevantArgs .= " --dodna=0 --dorna=1 --dodnarna=0 ";
			$dnarnaDIR = "RNA/";
			$irrelevantArgs .= " --domidist=1"
			}
		}
	$irrelevantArgs .= " --dogoclusters=0 --docons=0 --dogetprofiles==0 --dotargets=0 --dohistograms=0 --domicombine=0 --doagglo=0 --dogomotifs=0 --dodrawmotifmaps=0 --domotifnames=0 --dodnacomp=0 --domidrawdist=0 --domotifreport=0 ";
	#$irrelevantArgs .= " --domidist=0 --dogoclusters=0 --docons=0 --dogetprofiles==0 --dotargets=0 --dohistograms=0 --domicombine=0 --doagglo=0 --dogomotifs=0 --dodrawmotifmaps=0 --domotifnames=0 --dodnacomp=0 --domidrawdist=0 --domotifreport=0 ";
	# $irrelevantArgs .= "  --domisummarize=0 ";


	for (my $ix=0; $ix<$p->{crossval}; $ix++) 
		{
		my $cvtag     = $p->{outtag} . ".CV" . $ix;
		my $cvtag_tra = $cvtag . ".tra";
		my $trafile = $p->{crossvaldir} . "/" . $cvtag_tra;
		my $outfile = $p->{crossvaldir} . "/" . $cvtag_tra . ".out";
		my $errfile = $p->{crossvaldir} . "/" . $cvtag_tra . ".err";

		# run training
		my $firetodo = "perl $ENV{FIREDIR}/$fireprog ";
		$firetodo .= " --expfile=$trafile --j_nt=-1 ";
		$firetodo .= $relevantArgs;
		$firetodo .= $trainingonlyArgs;
#		$firetodo .= $mergeonlyArgs;
		$firetodo .= $irrelevantArgs;
		$todo .= "\necho \"$dnarnatag, Step 0.2: run fire on training set $trafile.\"";
		$todo .= "\n$firetodo \> $outfile 2\> $errfile ";
		}

	###############################################
	# Run non-discovery fire on testing sets
	###############################################

	$todo .=  "\nperl $p->{scriptdir}/create_cross_validation_test_motifs.pl -outtag $p->{outtag} -crossval $p->{crossval} -crossvaldir $p->{crossvaldir}  -dnarnaDIR $dnarnaDIR ";

	for (my $ix=0; $ix<$p->{crossval}; $ix++) 
		{
		my $cvtag     = $p->{outtag} . ".CV" . $ix;
		my $cvtag_tes = $cvtag . ".tes";
		my $testfile = $p->{crossvaldir} . "/" . $cvtag_tes;
		my $outfile  = $p->{crossvaldir} . "/" . $cvtag_tes . ".out";
		my $errfile  = $p->{crossvaldir} . "/" . $cvtag_tes . ".err";
		my $motfile  = $p->{crossvaldir} . "/" . $cvtag . ".motifs";
		
		# run testing 
		my $nondisctodo = "perl $ENV{FIREDIR}/$fireprog ";
		$nondisctodo .= " --expfiles=$testfile";
		$nondisctodo .= " --doskipdiscovery=1 --includenotsignif=1";
		$nondisctodo .= " --jn_t=-1 --shuffle=1000 --minr=-1 ";
		if ( defined( $p->{fordna} ) ) 
			{
			if($p->{fordna}==1)
				{
				$nondisctodo .= " --motiffile_dna=$motfile";
				}
			elsif ( (defined($p->{forrna})) && ($p->{forrna}==1) )
				{
				$nondisctodo .= " --motiffile_rna=$motfile --oribiasonly=0";
				}
			}
		$nondisctodo .= $relevantArgs;
 		$nondisctodo .= $irrelevantArgs;
		$todo .= "\necho \"$dnarnatag, Step 0.3: run fire on testing set $testfile.\"";
		$todo .= "\n$nondisctodo  \> $outfile 2\> $errfile ";
		}

	###############################################
	# Filter Training-set discovered Motifs
	###############################################

	$todo .= "\necho \"$dnarnatag, Step 0.4: Filter training motifs, keep the ones that validate.\"";

	for (my $ix=0; $ix<$p->{crossval}; $ix++) 
		{
		my $cvtag     = $p->{outtag} . ".CV" . $ix;
		my $cvtag_tes = $cvtag . ".tes";
		my $cvtag_tra = $cvtag . ".tra";

		my $trainsumfile = $p->{crossvaldir} . "/" . $cvtag_tra . "_FIRE/" . $dnarnaDIR . $cvtag_tra . ".summary";
		my $trainmatfile = $p->{crossvaldir} . "/" . $cvtag_tra . "_FIRE/" . $dnarnaDIR . $cvtag_tra . ".matrix";

		my $testsumfile  = $p->{crossvaldir} . "/" . $cvtag_tes . "_FIRE/" . $dnarnaDIR . $cvtag_tes . ".summary";
		my $testmatfile  = $p->{crossvaldir} . "/" . $cvtag_tes . "_FIRE/" . $dnarnaDIR . $cvtag_tes . ".matrix";

		my $motpassfile  = $p->{crossvaldir} . "/" . $cvtag . ".motifs.passed";

		$todo .=  "\nperl $p->{scriptdir}/read_crossvalidation_results.pl -outfile $motpassfile -train_summaryfile $trainsumfile -train_matfile $trainmatfile -test_summaryfile  $testsumfile  -test_matfile $testmatfile -zThreshold $p->{zThreshold} -corrThreshold $p->{corrThreshold} ";
		}


	###########################################################################################
	# Run original file Non-discovery with all the motifs from the cross validation runs
	# Keep minr=0.5, let similar motifs be filtered out
	###########################################################################################

	my $motpassfileALL = $p->{targetdir} . "/" . $p->{outtag} . ".comb_crossval_motifs";
	my $motpassfileALLtmp = $motpassfileALL . ".tmp";
	my $runfile = $p->{targetdir} . "/" . $p->{outtag};
	my $outfile = $p->{targetdir} . "/" . $p->{outtag} . ".out";
	my $errfile = $p->{targetdir} . "/" . $p->{outtag} . ".err";

	for (my $ix=0; $ix<$p->{crossval}; $ix++) 
		{
		my $cvtag     = $p->{outtag} . ".CV" . $ix;
		my $motpassfile  = $p->{crossvaldir} . "/" . $cvtag . ".motifs.passed";
		if($ix==0)
			{ $todo .=  "\ncat $motpassfile \> $motpassfileALLtmp "; }
		else
			{ $todo .=  "\ncat $motpassfile \>\> $motpassfileALLtmp "; }
		}
	# $todo .=  "\nsort -u $motpassfileALLtmp \>  $motpassfileALL ";
	$todo .=  "\nCNTM=`perl $p->{scriptdir}/count_lines.pl $motpassfileALLtmp`; if [ \$CNTM = 0 ]; then echo \"No $dnarnaDIR motifs.\"; rm \-rf $motpassfileALLtmp; fi";
	#$todo .=  "\n$p->{progdir}\/mi_motif_compare_1 -expfile $runfile -quantized $p->{quantized} -fastafile $p->{fastafile} -motiffile $motpassfileALLtmp -outfile  $motpassfileALL -rna $p->{forrna} $minrarg -compTH 0.95 ";
	$todo .=  "\n$p->{progdir}\/mi_motif_compare_1 -expfile $runfile -quantized $p->{quantized} -fastafile $p->{fastafile} -motiffile $motpassfileALLtmp -outfile  $motpassfileALL -rna $p->{forrna} -minr 0.3 -compTH 0.95 ";
	$todo .=  "\nCNTM=`perl $p->{scriptdir}/count_lines.pl $motpassfileALL`; if [ \$CNTM = 0 ]; then echo \"No $dnarnaDIR motifs.\"; rm \-rf $motpassfileALL; fi";

	# run merge
	my $nondisctodo = "perl $ENV{FIREDIR}/$fireprog ";
	$nondisctodo .= " --expfiles=$runfile";
	$nondisctodo .= " --doskipdiscovery=1 --includenotsignif=1";
	$nondisctodo .= " --jn_t=-1 ";
	if ( defined( $p->{fordna} ) ) 
		{
		if($p->{fordna}==1)
			{
			$nondisctodo .= " --motiffile_dna=$motpassfileALL";
			}
		elsif ( (defined($p->{forrna})) && ($p->{forrna}==1) )
			{
			$nondisctodo .= " --motiffile_rna=$motpassfileALL";
			}
		}
	$nondisctodo .= $relevantArgs;
	$nondisctodo .= $mergeonlyArgs;
	$todo .= "\necho \"$dnarnatag, Step 0.5: Run filtered motifs on the original dataset.\"";
	$todo .= "\n$nondisctodo  \> $outfile 2\> $errfile ";

	###########################################################################################
	# Copy FIRE files to the directory where they are supposed to be 
	# so that they can be found by the DNA_RNA routine
	###########################################################################################

	$todo .= "\necho \"$dnarnatag, Step 0.6: Copy files to $destdir.\"";

	my $scriptfileND  = $p->{targetdir} . "/" . $p->{outtag} . "_FIRE/" . $dnarnaDIR . $p->{outtag} . ".script";
	my $scriptfileNDS = $p->{targetdir} . "/" . $p->{outtag} . ".script.nonDisc";

	my $scriptfileCV  = $p->{targetdir} . "/" . $p->{outtag} . ".script";
	my $scriptfileCVS = $p->{targetdir} . "/" . $p->{outtag} . ".script.CV";

	my $scrdir 	= $p->{targetdir} . "/" . $p->{outtag} . "_FIRE/" . $dnarnaDIR;
	my $destdir 	= $p->{targetdir} . "/";

	$todo .= "\ncp $scriptfileND $scriptfileNDS ";
	$todo .= "\ncp $scriptfileCV $scriptfileCVS ";
	$todo .= "\nmv $scrdir\* $destdir ";

	return $todo;
}




sub get_cmd_removedups 
{
	my ($p) = @_;

	my $todo = "perl $p->{scriptdir}/remove_homologous_sequences_withseed.pl -expfile $p->{expfile} -quantized $p->{quantized} -fastafile $p->{fastafile} -outfile $p->{outfile}";
	if ( defined( $p->{dupfile} ) ) {
		$todo .= " -dupfile $p->{dupfile} ";
	}

	if ( defined( $p->{ebins} ) ) {
		$todo .= " -ebins $p->{ebins} ";
	}

	if ( defined( $p->{divbins} ) ) {
		$todo .= " -divbins $p->{divbins} ";
	}



	return $todo;
}





sub get_cmd_mifind {
	my ($p) = @_;

	my $todo = "$p->{progdir}/mi_find -expfile $p->{expfile} -quantized $p->{quantized} -fastafile $p->{fastafile} -outfile $p->{seedfile} -report 1 -docor 1 -outprm 1 -shuffle $p->{shuffle} -jn 0 -jn_t 0 -verbose 1 -rna $p->{rna}";

	if ( defined( $p->{kmerfile} ) ) {
		$todo .= " -kmerfile $p->{kmerfile} ";
	}

	if ( defined( $p->{ebins} ) ) {
		$todo .= " -ebins $p->{ebins} ";
	}

	#if (defined($p->{fast}) && ($p->{fast} == 0)) {
	#  $todo .= " -fast 0 ";
	#}
	if ( defined( $p->{mbins} ) ) {
		$todo .= " -mbins $p->{mbins} ";
	}

	if ( defined( $p->{divbins} ) ) {
		$todo .= " -divbins $p->{divbins} ";
	}

	if ( defined( $p->{maxselected} ) ) {
		$todo .= " -max_selected $p->{maxselected} ";
	}

	if ( defined( $p->{k} ) ) {
		$todo .= " -k $p->{k} ";
	}

	if ( defined( $p->{gap} ) ) {
		$todo .= " -gap $p->{gap} ";
	}

	return $todo;

}

sub get_cmd_mioptimize {

	my ($p) = @_;

	my $todo = "";

	if ( $p->{optimslow} == 0 ) {

		$todo = "$p->{progdir}/mi_optimize_X -expfile $p->{expfile} -quantized $p->{quantized} -fastafile $p->{fastafile} -outfile $p->{optimfile} -kmerfile $p->{seedfile} -shuffle $p->{shuffle} -report 0 -log 1 -rna $p->{rna} -verbose 0 -mask 0 -minr $p->{minr} -maxfreq $p->{maxfreq}";

	}
	else {

		$todo = "$p->{progdir}/mi_optimize_slow -expfile $p->{expfile} -quantized $p->{quantized} -fastafile $p->{fastafile} -outfile $p->{optimfile} -kmerfile $p->{seedfile} -shuffle $p->{shuffle} -report 0 -log 1 -rna $p->{rna}";

	}

	if ( defined( $p->{mbins} ) ) {
		$todo .= " -mbins $p->{mbins} ";
	}

	if ( defined( $p->{add} ) ) {
		$todo .= " -add $p->{add} ";
	}

	if ( defined( $p->{gap} ) ) {
		$todo .= " -gap $p->{gap} ";
	}

	if ( defined( $p->{ebins} ) ) {
		$todo .= " -ebins $p->{ebins} ";
	}

	if ( defined( $p->{divbins} ) ) {
		$todo .= " -divbins $p->{divbins} ";
	}

	if ( defined( $p->{maxdegeneracy} ) ) {
		$todo .= " -maxdegeneracy $p->{maxdegeneracy} ";
	}

	if ( defined( $p->{no_neg_cor} ) ) {
		$todo .= " -no_neg_cor $p->{no_neg_cor} ";
	}

	return $todo;
}


sub get_cmd_mioptimize_maxdeg {

	my ($p) = @_;

	my $todo = "";

	if ( $p->{optimslow} == 0 ) {

		$todo = "$p->{progdir}/mi_optimize_maxdeg_X -expfile $p->{expfile} -quantized $p->{quantized} -fastafile $p->{fastafile} -outfile $p->{optimfile} -kmerfile $p->{seedfile} -shuffle $p->{shuffle} -report 0 -log 1 -rna $p->{rna} -verbose 0 -mask 0 -minr $p->{minr} -maxfreq $p->{maxfreq}";

	}
	else {

		$todo = "$p->{progdir}/mi_optimize_slow -expfile $p->{expfile} -quantized $p->{quantized} -fastafile $p->{fastafile} -outfile $p->{optimfile} -kmerfile $p->{seedfile} -shuffle $p->{shuffle} -report 0 -log 1 -rna $p->{rna}";

	}

	if ( defined( $p->{mbins} ) ) {
		$todo .= " -mbins $p->{mbins} ";
	}

	if ( defined( $p->{add} ) ) {
		$todo .= " -add $p->{add} ";
	}

	if ( defined( $p->{gap} ) ) {
		$todo .= " -gap $p->{gap} ";
	}

	if ( defined( $p->{ebins} ) ) {
		$todo .= " -ebins $p->{ebins} ";
	}

	if ( defined( $p->{divbins} ) ) {
		$todo .= " -divbins $p->{divbins} ";
	}

	if ( defined( $p->{maxdegeneracy} ) ) {
		$todo .= " -maxdegeneracy $p->{maxdegeneracy} ";
	}

	if ( defined( $p->{no_neg_cor} ) ) {
		$todo .= " -no_neg_cor $p->{no_neg_cor} ";
	}

	return $todo;
}


sub get_cmd_misignif {
	my ($p) = @_;

	my $todo ="$p->{progdir}/mi_signif -expfile $p->{expfile} -quantized $p->{quantized} -fastafile $p->{fastafile} -motiffile $p->{optimfile} -shuffle $p->{shuffle} -outfile $p->{signiffile} -rna $p->{rna} -jn $p->{jn} -jn_t $p->{jn_t} -jn_f $p->{jn_f} ";


	if ( defined( $p->{ebins} ) ) {
		$todo .= " -ebins $p->{ebins} ";
	}

	if ( defined( $p->{optimout} ) ) {
		$todo .= " -optimout $p->{optimout} ";
	}
	else
	{
		$todo .= " -optimout 1 ";
	}

	if ( defined( $p->{mbins} ) ) {
		$todo .= " -mbins $p->{mbins} ";
	}

	if ( defined( $p->{divbins} ) ) {
		$todo .= " -divbins $p->{divbins} ";
	}

	if ( defined( $p->{doreportonly} ) ) {
		$todo .= " -doreportonly $p->{doreportonly} ";
	}

	return $todo;

}

sub get_cmd_midist {

	# my ($expfile, $quantized, $fastafile, $rna, $optimfile, $shuffle, $mbins_interval, $donbcopies, $outfile) = @_;
	my ($p) = @_;

	my $todo = "$p->{progdir}/mi_dist -expfile $p->{expfile} -expfile_b $p->{expfile_b} -quantized $p->{quantized} -fastafile $p->{fastafile} -motiffile $p->{optimfile} -shuffle $p->{shuffle} -outfile $p->{distfile} -mbins_interval $p->{mbins_interval} -rna $p->{rna} -donbcopies $p->{donbcopies}";

	if ( defined( $p->{ebins} ) ) {
		$todo .= " -ebins $p->{ebins} ";
	}

	if ( defined( $p->{divbins} ) ) {
		$todo .= " -divbins $p->{divbins} ";
	}

	return $todo;
}

sub get_cmd_midist_mbins {

	# my ($expfile, $quantized, $fastafile, $rna, $optimfile, $shuffle, $mbins_interval, $donbcopies, $outfile) = @_;
	my ($p) = @_;

	my $todo = "$p->{progdir}/mi_dist_mbins -expfile $p->{expfile} -expfile_b $p->{expfile_b} -quantized $p->{quantized} -fastafile $p->{fastafile} -motiffile $p->{optimfile} -shuffle $p->{shuffle} -outfile $p->{distfile} -mbins_interval $p->{mbins_interval} -rna $p->{rna} -donbcopies $p->{donbcopies}";

	if ( defined( $p->{ebins} ) ) {
		$todo .= " -ebins $p->{ebins} ";
	}

	if ( defined( $p->{divbins} ) ) {
		$todo .= " -divbins $p->{divbins} ";
	}

	if ( defined( $p->{mbins} ) ) {
		$todo .= " -mbins $p->{mbins} ";
	}

	return $todo;
}


sub get_cmd_misummarize {
	my ($p) = @_;

	#my ($expfile_nodups_dna, $fastafile_dna, $optimfile_dna, $signiffile_dna, $distfile_dna, $consfile_dna,
	#    $expfile_nodups_rna, $fastafile_rna, $optimfile_rna, $signiffile_rna, $distfile_rna, $consfile_rna,
	#    $rna, $quantized, $minrobustness,
	#    $removecols_draw, $sortrowsbyphase,
	#    $outsummary, $outmatrix, $outcolumns, $outgoodcolumns, $outnames, $outexpfile) = @_;

	my $todo = "perl $p->{scriptdir}/mi_summarize_fix.pl ";

	if ( ( $p->{rna} == 0 ) || ( $p->{rna} == 2 ) ) {
		$todo .= " -optimfile_dna $p->{optimfile_dna} -statfile_dna $p->{signiffile_dna} -distfile_dna $p->{distfile_dna} ";
	}

	if ( ( $p->{rna} == 1 ) || ( $p->{rna} == 2 ) ) {
		$todo .= " -optimfile_rna $p->{optimfile_rna} -statfile_rna $p->{signiffile_rna} -distfile_rna $p->{distfile_rna} ";
	}

	if ( $p->{rna} == 2 ) {
		$todo .= " -expfile_dna $p->{expfile_dna} -expfile_rna $p->{expfile_rna} -outexpfile $p->{outexpfile} ";
	}

	$todo .= " -quantized $p->{quantized} -outmatrix $p->{matrixfile} -outfullmatrix $p->{fullmatrixfile} -outdensitymatrix $p->{densityfile} -outcolumns $p->{columnsfile} -outgoodcolumns $p->{signifcolumnsfile} -outnames $p->{namesfile} -outsummary $p->{summaryfile} -removecols_exp 0 -minrobustness $p->{minrobustness} -outlevel $p->{outlevel} -maxrobustness $p->{maxrobustness} ";

	if ( defined( $p->{removecols_draw} ) ) {
		$todo .= " -removecols_draw $p->{removecols_draw} ";
	}

	if ( defined( $p->{consfile_dna} ) ) {
		$todo .= " -consfile_dna $p->{consfile_dna} ";
	}

	if ( defined( $p->{consfile_rna} ) ) {
		$todo .= " -consfile_rna $p->{consfile_rna} ";
	}

	if ( defined( $p->{motifrepfile_dna} ) ) {
		$todo .= " -motifrepfile_dna $p->{motifrepfile_dna} ";
	}

	if ( defined( $p->{motifrepfile_rna} ) ) {
		$todo .= " -motifrepfile_rna $p->{motifrepfile_rna} ";
	}

	if ( defined( $p->{minp} ) ) {
		$todo .= " -minp $p->{minp} ";
	}

	if ( defined( $p->{minz} ) ) {
		$todo .= " -minz $p->{minz} ";
	}

	if ( defined( $p->{oribiasonly} ) ) {
		$todo .= " -oribiasonly $p->{oribiasonly} ";
	}

	if ( defined( $p->{keeprnabidir} ) ) {
		$todo .= " -keeprnabidir $p->{keeprnabidir} ";
	}

	if ( defined( $p->{expfile_b_dna} ) ) {
		$todo .= " -expfile_b_dna $p->{expfile_b_dna} ";
	}

	if ( defined( $p->{expfile_b_rna} ) ) {
		$todo .= " -expfile_b_rna $p->{expfile_b_rna} ";
	}

	if ( defined( $p->{outexpfile_b} ) ) {
		$todo .= " -outexpfile_b $p->{outexpfile_b} ";
	}

	$todo .= " -sortrowsbyphase $p->{sortrowsbyphase} ";

	if ( defined( $p->{includenotsignif} ) ) {
		$todo .= " -includenotsignif $p->{includenotsignif} ";
	}

	return $todo;

}



sub get_cmd_misummarize_mbins {
	my ($p, $mbins) = @_;
	
	#my ($expfile_nodups_dna, $fastafile_dna, $optimfile_dna, $signiffile_dna, $distfile_dna, $consfile_dna,
	#    $expfile_nodups_rna, $fastafile_rna, $optimfile_rna, $signiffile_rna, $distfile_rna, $consfile_rna,
	#    $rna, $quantized, $minrobustness,
	#    $removecols_draw, $sortrowsbyphase,
	#    $outsummary, $outmatrix, $outcolumns, $outgoodcolumns, $outnames, $outexpfile) = @_;

	my $todo = "perl $p->{scriptdir}/mi_summarize_fix.pl ";

	if ( ( $p->{rna} == 0 ) || ( $p->{rna} == 2 ) ) {
		$todo .= " -optimfile_dna $p->{optimfile_dna} -statfile_dna $p->{signiffile_dna} -distfile_dna $p->{distfile_dna} ";
	}

	if ( ( $p->{rna} == 1 ) || ( $p->{rna} == 2 ) ) {
		$todo .= " -optimfile_rna $p->{optimfile_rna} -statfile_rna $p->{signiffile_rna} -distfile_rna $p->{distfile_rna} ";
	}

	if ( $p->{rna} == 2 ) {
		$todo .= " -expfile_dna $p->{expfile_dna} -expfile_rna $p->{expfile_rna} -outexpfile $p->{outexpfile} ";
	}

	$todo .= " -quantized $p->{quantized} -outmatrix $p->{matrixfile} -outfullmatrix $p->{fullmatrixfile} -outdensitymatrix $p->{densityfile} -outcolumns $p->{columnsfile} -outgoodcolumns $p->{signifcolumnsfile} -outnames $p->{namesfile} -outsummary $p->{summaryfile} -removecols_exp 0 -minrobustness $p->{minrobustness} -outlevel $p->{outlevel} -maxrobustness $p->{maxrobustness} ";

	if ( defined( $p->{removecols_draw} ) ) {
		$todo .= " -removecols_draw $p->{removecols_draw} ";
	}

	if ( defined( $p->{consfile_dna} ) ) {
		$todo .= " -consfile_dna $p->{consfile_dna} ";
	}

	if ( defined( $p->{consfile_rna} ) ) {
		$todo .= " -consfile_rna $p->{consfile_rna} ";
	}

	if ( defined( $p->{motifrepfile_dna} ) ) {
		$todo .= " -motifrepfile_dna $p->{motifrepfile_dna} ";
	}

	if ( defined( $p->{motifrepfile_rna} ) ) {
		$todo .= " -motifrepfile_rna $p->{motifrepfile_rna} ";
	}

	if ( defined( $p->{minp} ) ) {
		$todo .= " -minp $p->{minp} ";
	}

	if ( defined( $p->{minz} ) ) {
		$todo .= " -minz $p->{minz} ";
	}

	if ( defined( $p->{oribiasonly} ) ) {
		$todo .= " -oribiasonly $p->{oribiasonly} ";
	}

	if ( defined( $p->{keeprnabidir} ) ) {
		$todo .= " -keeprnabidir $p->{keeprnabidir} ";
	}


	if ( defined( $p->{expfile_b_dna} ) ) {
		$todo .= " -expfile_b_dna $p->{expfile_b_dna} ";
	}

	if ( defined( $p->{expfile_b_rna} ) ) {
		$todo .= " -expfile_b_rna $p->{expfile_b_rna} ";
	}

	if ( defined( $p->{outexpfile_b} ) ) {
		$todo .= " -outexpfile_b $p->{outexpfile_b} ";
	}

	$todo .= " -sortrowsbyphase $p->{sortrowsbyphase} ";

	if ( defined( $p->{includenotsignif} ) ) {
		$todo .= " -includenotsignif $p->{includenotsignif} ";
	}

	if($mbins>2)
	{
	$todo .= "\nperl $p->{scriptdir}/mi_summarize_mbins3.pl ";
	#$todo .= "\nperl $scriptdir/mi_summarize_mbins3.pl ";
	if ( ( $p->{rna} == 0 ) || ( $p->{rna} == 2 ) ) { $todo .= " -optimfile_dna $p->{optimfile_dna} -statfile_dna $p->{signiffile_dna} -distfile_dna $p->{distfile_dna} "; }
	if ( ( $p->{rna} == 1 ) || ( $p->{rna} == 2 ) ) { $todo .= " -optimfile_rna $p->{optimfile_rna} -statfile_rna $p->{signiffile_rna} -distfile_rna $p->{distfile_rna} "; }
	if ( $p->{rna} == 2 ) { $todo .= " -expfile_dna $p->{expfile_dna} -expfile_rna $p->{expfile_rna} -outexpfile $p->{outexpfile} "; }
	$todo .= " -quantized $p->{quantized} -outmatrix $p->{matrixfile}.mbins3 -outfullmatrix $p->{fullmatrixfile}.mbins3 -outdensitymatrix $p->{densityfile}.mbins3 -outcolumns $p->{columnsfile}.mbins3 -outgoodcolumns $p->{signifcolumnsfile}.mbins3 -outnames $p->{namesfile}.mbins3 -outsummary $p->{summaryfile}.mbins3 -removecols_exp 0 -minrobustness $p->{minrobustness} -outlevel $p->{outlevel} -maxrobustness $p->{maxrobustness} ";
	if ( defined( $p->{removecols_draw} ) ) { $todo .= " -removecols_draw $p->{removecols_draw} "; }
	if ( defined( $p->{consfile_dna} ) ) { $todo .= " -consfile_dna $p->{consfile_dna} "; }
	if ( defined( $p->{consfile_rna} ) ) { $todo .= " -consfile_rna $p->{consfile_rna} "; }
	if ( defined( $p->{motifrepfile_dna} ) ) { $todo .= " -motifrepfile_dna $p->{motifrepfile_dna} "; }
	if ( defined( $p->{motifrepfile_rna} ) ) { $todo .= " -motifrepfile_rna $p->{motifrepfile_rna} "; }
	if ( defined( $p->{minp} ) ) { $todo .= " -minp $p->{minp} "; }
	if ( defined( $p->{minz} ) ) { $todo .= " -minz $p->{minz} "; }
	if ( defined( $p->{oribiasonly} ) ) { $todo .= " -oribiasonly $p->{oribiasonly} "; }
	if ( defined( $p->{keeprnabidir} ) ) { $todo .= " -keeprnabidir $p->{keeprnabidir} "; }
	if ( defined( $p->{expfile_b_dna} ) ) { $todo .= " -expfile_b_dna $p->{expfile_b_dna} "; }
	if ( defined( $p->{expfile_b_rna} ) ) {	$todo .= " -expfile_b_rna $p->{expfile_b_rna} "; }
	if ( defined( $p->{outexpfile_b} ) ) { $todo .= " -outexpfile_b $p->{outexpfile_b}.mbins3 "; }
	$todo .= " -sortrowsbyphase $p->{sortrowsbyphase} ";
	if ( defined( $p->{includenotsignif} ) ) { $todo .= " -includenotsignif $p->{includenotsignif} "; }
	}

	if($mbins>3)
	{
	$todo .= "\nperl $p->{scriptdir}/mi_summarize_mbins4.pl ";
	#$todo .= "\nperl $scriptdir/mi_summarize_mbins4.pl ";
	if ( ( $p->{rna} == 0 ) || ( $p->{rna} == 2 ) ) { $todo .= " -optimfile_dna $p->{optimfile_dna} -statfile_dna $p->{signiffile_dna} -distfile_dna $p->{distfile_dna} "; }
	if ( ( $p->{rna} == 1 ) || ( $p->{rna} == 2 ) ) { $todo .= " -optimfile_rna $p->{optimfile_rna} -statfile_rna $p->{signiffile_rna} -distfile_rna $p->{distfile_rna} "; }
	if ( $p->{rna} == 2 ) { $todo .= " -expfile_dna $p->{expfile_dna} -expfile_rna $p->{expfile_rna} -outexpfile $p->{outexpfile} "; }
	$todo .= " -quantized $p->{quantized} -outmatrix $p->{matrixfile}.mbins4 -outfullmatrix $p->{fullmatrixfile}.mbins4 -outdensitymatrix $p->{densityfile}.mbins4 -outcolumns $p->{columnsfile}.mbins4 -outgoodcolumns $p->{signifcolumnsfile}.mbins4 -outnames $p->{namesfile}.mbins4 -outsummary $p->{summaryfile}.mbins4 -removecols_exp 0 -minrobustness $p->{minrobustness} -outlevel $p->{outlevel} -maxrobustness $p->{maxrobustness} ";
	if ( defined( $p->{removecols_draw} ) ) { $todo .= " -removecols_draw $p->{removecols_draw} "; }
	if ( defined( $p->{consfile_dna} ) ) { $todo .= " -consfile_dna $p->{consfile_dna} "; }
	if ( defined( $p->{consfile_rna} ) ) { $todo .= " -consfile_rna $p->{consfile_rna} "; }
	if ( defined( $p->{motifrepfile_dna} ) ) { $todo .= " -motifrepfile_dna $p->{motifrepfile_dna} "; }
	if ( defined( $p->{motifrepfile_rna} ) ) { $todo .= " -motifrepfile_rna $p->{motifrepfile_rna} "; }
	if ( defined( $p->{minp} ) ) { $todo .= " -minp $p->{minp} "; }
	if ( defined( $p->{minz} ) ) { $todo .= " -minz $p->{minz} "; }
	if ( defined( $p->{oribiasonly} ) ) { $todo .= " -oribiasonly $p->{oribiasonly} "; }
	if ( defined( $p->{keeprnabidir} ) ) { $todo .= " -keeprnabidir $p->{keeprnabidir} "; }
	if ( defined( $p->{expfile_b_dna} ) ) { $todo .= " -expfile_b_dna $p->{expfile_b_dna} "; }
	if ( defined( $p->{expfile_b_rna} ) ) {	$todo .= " -expfile_b_rna $p->{expfile_b_rna} "; }
	if ( defined( $p->{outexpfile_b} ) ) { $todo .= " -outexpfile_b $p->{outexpfile_b}.mbins4 "; }
	$todo .= " -sortrowsbyphase $p->{sortrowsbyphase} ";
	if ( defined( $p->{includenotsignif} ) ) { $todo .= " -includenotsignif $p->{includenotsignif} "; }
	}

	
	return $todo;

}



sub get_cmd_micombine {

	#my ($expfile_nodups, $quantized,
	#    $fastafile_dna, $fastafile_rna, $summaryfile,
	#    $poscor, $doallstats,
	#    $clusterfile, $mimatrixfile, $fullmimatrix) = @_;

	my ($p) = @_;

	my $todo = "$p->{progdir}/mi_combine -expfile $p->{expfile}";

	if ( defined( $p->{fastafile_dna} ) ) {
		$todo .= " -fastafile_dna $p->{fastafile_dna} ";
	}

	if ( defined( $p->{fastafile_rna} ) ) {
		$todo .= " -fastafile_rna $p->{fastafile_rna} ";
	}

	$todo .= " -summaryfile $p->{summaryfile} -quantized $p->{quantized} -outfile $p->{clusterfile} -outmimatrix $p->{mimatrixfile} -outfullmimatrix $p->{fullmimatrixfile} -poscor $p->{poscor} -doallstats $p->{doallstats} ";

	return $todo;

}

sub get_cmd_micombine_mbins {

	#my ($expfile_nodups, $quantized,
	#    $fastafile_dna, $fastafile_rna, $summaryfile,
	#    $poscor, $doallstats,
	#    $clusterfile, $mimatrixfile, $fullmimatrix) = @_;

	my ($p) = @_;

	my $todo = "$p->{progdir}/mi_combine_mbins -expfile $p->{expfile}";

	if ( defined( $p->{fastafile_dna} ) ) {
		$todo .= " -fastafile_dna $p->{fastafile_dna} ";
	}

	if ( defined( $p->{fastafile_rna} ) ) {
		$todo .= " -fastafile_rna $p->{fastafile_rna} ";
	}

	if ( defined( $p->{mbins} ) ) {
		$todo .= " -mbins $p->{mbins} ";
	}

	$todo .= " -summaryfile $p->{summaryfile} -quantized $p->{quantized} -outfile $p->{clusterfile} -outmimatrix $p->{mimatrixfile} -outfullmimatrix $p->{fullmimatrixfile} -poscor $p->{poscor} -doallstats $p->{doallstats} ";

	return $todo;

}

sub get_cmd_midrawmatrix {
	my ($p) = @_;

	my $todo = "perl $p->{scriptdir}/mi_draw_matrix.pl --expfile=$p->{expfile} --matfile=$p->{matrixfile} --summaryfile=$p->{summaryfile} --columnsfile=$p->{columnsfile} --ps2pdf=$p->{ps2pdf} --every=$p->{every} --quantized=$p->{quantized} --motifnames=$p->{namesfile} --ybase=250";

	if ( defined( $p->{colmap} ) ) {
		$todo .= " --colmap=$p->{colmap} ";
	}

	if ( defined( $p->{clusterfile} ) ) {
		$todo .= " --clustfile=$p->{clusterfile} ";
	}

	if ( defined( $p->{densityfile} ) ) {
		$todo .= " --densityfile=$p->{densityfile} ";
	}

	if ( defined( $p->{redoweblogo} ) ) {
		$todo .= " --redoweblogo=$p->{redoweblogo} ";
	}

	if ( defined( $p->{outeps} ) ) {
		$todo .= " --outeps=$p->{outeps} ";
	}

	if ( defined( $p->{gofile} ) ) {
		$todo .= " --gofile=$p->{gofile} ";
	}

	if ( defined( $p->{lp_t_draw} ) ) {
		$todo .= " --lp_t_draw=$p->{lp_t_draw} ";
	}

	return $todo;
}

sub get_cmd_midrawinteractions {
	my ($p) = @_;

	my $todo = "perl $p->{scriptdir}/mi_draw_interaction_matrix.pl -summaryfile $p->{summaryfile} -matrixfile $p->{fullmimatrixfile} -resmatrixfile $p->{mimatrixfile} -motifdir $p->{motifdir} ";
	if ( defined( $p->{clusterfile} ) ) {
		$todo .= " -clustfile $p->{clusterfile} ";
	}
	if ( defined( $p->{orderfile} ) ) {
		$todo .= " -orderfile $p->{orderfile} ";
	}
	return $todo;
}

sub get_cmd_midrawmatrix_html {
	my ($p) = @_;

	my $todo = "perl $p->{scriptdir}/mi_draw_matrix_html.pl --expfile=$p->{expfile} --matfile=$p->{matrixfile} --summaryfile=$p->{summaryfile} --columnsfile=$p->{columnsfile} --ps2pdf=$p->{ps2pdf} --every=$p->{every} --quantized=$p->{quantized} --motifnames=$p->{namesfile} --ybase=250";

	if ( defined( $p->{colmap} ) ) {
		$todo .= " --colmap=$p->{colmap} ";
	}

	if ( defined( $p->{clusterfile} ) ) {
		$todo .= " --clustfile=$p->{clusterfile} ";
	}

	if ( defined( $p->{densityfile} ) ) {
		$todo .= " --densityfile=$p->{densityfile} ";
	}

	if ( defined( $p->{redoweblogo} ) ) {
		$todo .= " --redoweblogo=$p->{redoweblogo} ";
	}

	if ( defined( $p->{outeps} ) ) {
		$todo .= " --outeps=$p->{outeps} ";
	}

	if ( defined( $p->{gofile} ) ) {
		$todo .= " --gofile=$p->{gofile} ";
	}

	if ( defined( $p->{lp_t_draw} ) ) {
		$todo .= " --lp_t_draw=$p->{lp_t_draw} ";
	}

	my $outfile = $p->{outfile};
	$todo .= " --outfile=$outfile ";

	return $todo;
}

sub get_cmd_midrawinteractions_html {
	my ($p) = @_;

	my $todo = "perl $p->{scriptdir}/mi_draw_interaction_matrix_html.pl -summaryfile $p->{summaryfile} -matrixfile $p->{fullmimatrixfile} -resmatrixfile $p->{mimatrixfile} -motifdir $p->{motifdir} ";
	if ( defined( $p->{clusterfile} ) ) {
		$todo .= " -clustfile $p->{clusterfile} ";
	}
	if ( defined( $p->{orderfile} ) ) {
		$todo .= " -orderfile $p->{orderfile} ";
	}

	my $outfile = $p->{fullmimatrixfile} . '.html';
	$todo .= " -outfile $outfile ";

	return $todo;
}


sub get_cmd_optimizetowm_dnarna {
	my ($p) = @_;

	my $todo = "perl $p->{morescriptdir}/optimize_each_motif_to_WM_using_grid_dnarna.pl --expfile=$p->{expfile} --fastafile_dna=$p->{fastafile_dna} --fastafile_rna=$p->{fastafile_rna} --ebins=$p->{ebins} --quantized=$p->{quantized} --submit=1 ";

	return $todo;
}

sub get_cmd_optimizetoextend_dnarna {
	my ($p) = @_;

	my $todo = "perl $p->{morescriptdir}/optimize_each_motif_using_grid_dnarna.pl --expfile=$p->{expfile} --fastafile_dna=$p->{fastafile_dna} --fastafile_rna=$p->{fastafile_rna} --ebins=$p->{ebins} --quantized=$p->{quantized} --submit=1 ";

	return $todo;
}

sub get_cmd_optimizetoextend_dna {
	my ($p) = @_;

	my $todo = "perl $p->{morescriptdir}/optimize_each_motif_using_grid_dna.pl --expfile=$p->{expfile} --fastafile_dna=$p->{fastafile_dna} --fastafile_rna=$p->{fastafile_rna} --ebins=$p->{ebins} --quantized=$p->{quantized} --submit=1 ";

	return $todo;
}

sub get_cmd_optimizetoextend_rna {
	my ($p) = @_;

	my $todo = "perl $p->{morescriptdir}/optimize_each_motif_using_grid_rna.pl --expfile=$p->{expfile} --fastafile_dna=$p->{fastafile_dna} --fastafile_rna=$p->{fastafile_rna} --ebins=$p->{ebins} --quantized=$p->{quantized} --submit=1 ";

	return $todo;
}

sub get_cmd_optimizetowm_dna {
	my ($p) = @_;

	my $todo = "perl $p->{morescriptdir}/optimize_each_motif_to_WM_using_grid_dna.pl --expfile=$p->{expfile} --fastafile_dna=$p->{fastafile_dna} --ebins=$p->{ebins} --quantized=$p->{quantized} --submit=1 ";

	return $todo;
}

sub get_cmd_optimizetowm_rna {
	my ($p) = @_;

	my $todo = "perl $p->{morescriptdir}/optimize_each_motif_to_WM_using_grid_rna.pl --expfile=$p->{expfile} --fastafile_rna=$p->{fastafile_rna} --ebins=$p->{ebins} --quantized=$p->{quantized} --submit=1 ";

	return $todo;
}




sub check_input_file {
	my ( $expfile, $exptype ) = @_;

	my $ta = Table->new;
	$ta->loadFile($expfile);
	my $a_ref = $ta->getArray();

	my $r = shift @$a_ref;
	if ( $r->[1] =~ /^\d/ ) {
		print "WARNING: your file might not contain a header line ($r->[1]).\n";
	}

	my %H = ();
	my %V = ();
	foreach my $r (@$a_ref) {
		if ( defined( $H{ $r->[0] } ) ) {
			print "Your files contains multiple rows with the same gene id. Please correct that before applying FIRE.\n";
			return 0;
		}
		$H{ $r->[0] }++;
		$V{ $r->[1] } = 1;
	}

	my @v = values(%V);
	@v = sort { $a <=> $b } @v;
	my $max = $#v;
	if ( ( $exptype eq 'discrete' ) && ( scalar(@v) != $max + 1 ) ) {
		my $n1 = scalar(@v);
		my $n2 = $max + 1;
		die "Problem. Your discrete vector is missing some symbols ($n1 != $n2).\n";
		return 0;
	}

	return 1;
}

sub readSpeciesData {
	my ($species) = @_;

	my %H = ();
	open IN, "$ENV{FIREDIR}/FIRE_DATA/SPECIES_DATA/$species"
	  or die "No data file for $species.\n";
	while ( my $l = <IN> ) {
		chomp $l;
		my @a = split /\t/, $l, -1;
		if ( $a[1] =~ /^FIRE_DATA/ ) {
			$a[1] = "$ENV{FIREDIR}/$a[1]";
		}
		$H{ $a[0] } = $a[1];
	}
	close IN;

	return \%H;
}





