#!/usr/bin/env python

"""
Splits file up based on method so we can do monophyly test more quickly in parallel
"""

import os
import sys


import csv

from collections import defaultdict



filename = sys.argv[1]


seq_dict = defaultdict(list)
with open(filename,'r') as in_fp:
	table = csv.reader(in_fp, delimiter="\t")
	for row in table:
		method = row[0]
		size = row[1]
		seqfile = row[2]
		seq_dict[method].append(seqfile)


for method in seq_dict:
	output = method+"_GroupGeneTree.tsv"
	with open(output,'w') as out_fp:
		tsv_writer = csv.writer(out_fp)
		for seqfile in seq_dict[method]:
			tsv_writer.writerow([seqfile])





