#!/usr/bin/env python

import pandas as pd

import csv
import os

import sys


FILENAME = sys.argv[1]
OUTPUT = sys.argv[2]


def get_genetree(OG,GENE_TREE_DIRECTORY):
	gene_id = os.path.basename(OG)
	gene_name = gene_id + ".phy_phyml_tree.txt"
	genetree_loc = os.path.join(GENE_TREE_DIRECTORY,gene_name)
	gene_tree = get_tree(genetree_loc)
	return gene_tree


def get_tree(filename):
	with open(filename,'r') as in_fp:
		tree = in_fp.readline()
		tree = tree.rstrip()
		return tree




df = pd.read_csv(FILENAME,sep="\t",header=None)

with open(OUTPUT,'w') as out_fp:
	tsv_writer = csv.writer(out_fp,delimiter="\t")
	newrow = ["Method","GroupSize","SeqID","Tree"]
	tsv_writer.writerow(newrow)
	for index,row in df.iterrows():
		method = row[0]
		groupsize = row[1]
		OG = row[2]
		print(method)
		print(groupsize)
		print(OG)
		seq_id = os.path.basename(OG)
		gene_tree_loc = os.path.join("/SAN/biosciences/oma/research/jeremy_levy/OMAStandalone/GeneTrees",method)
		tree = get_genetree(OG,gene_tree_loc)
		newrow = [method,groupsize,seq_id,tree]
		tsv_writer.writerow(newrow)






