#!/usr/bin/env python

"""
Create Tree table from File list
"""

import sys
import os

import csv

filename = sys.argv[1]
output = sys.argv[2]


def get_tree(filename):
	with open(filename,'r') as in_fp:
		line = in_fp.readline()
		tree = line.rstrip()
	return tree


with open(output,'w') as out_fp:
	tsv_writer = csv.writer(out_fp,delimiter="\t")
	row = ["Method","OG","Tree"]
	tsv_writer.writerow(row)
	with open(filename,'r') as in_fp:
		line = in_fp.readline()
		while(line):
			tree = get_tree(line.rstrip())
			method = filename.split("_")[0]
			OG = os.path.basename(line).split(".")[0]
			row = [method,OG,tree]
			tsv_writer.writerow(row)
			line = in_fp.readline()





