#!/usr/bin/env python

import os, sys
import datetime
import time
import subprocess

if __name__ == '__main__':

    """
    This is the wrapper template that is used by anduril/Crunch to submit jobs to the cluster.
    In the params.yaml file of Crunch one can define several queues (long, long_hm, verlong etcetera).
    For each queue one can give a string of addiotional parameters that are then inserted here.
    """

    ##The command that gets executed by anduril-remote (using the eval command) looks like this:
    ##./wrapper.py /import/bc2/home/nimwegen/GROUP/local/bin/python /import/bc2/home/nimwegen/...../PipeLine140113/COMPONENTS/transform/transform_anduril.py /import/bc2/home/nimwegen/..../IggrabTNFAaBG/OUTPUT/NFKB_4-trans/_command
    ##wrapper.py PYTHON COMPONENT_WRAPPER_SCRIPT COMMAND_FILE

    #this could theoretically also be a perl path if I would use perl wrappers to run components...
    pythonpath = sys.argv[1]
    component_wrapper = sys.argv[2] #this one doesn't have to be executable
    commandfile = sys.argv[3]

    # 'membycore=5G, runtime=6:00:00, n_nodes=16'
    queue_params = 'ADDITIONAL_PARAMETERS'
    qp = queue_params.split(',')
    mem_limit = qp[0].split('=')[1] 
    time_limit = qp[1].split('=')[1] 
    n_nodes = qp[2].split('=')[1] 

    crunch_env = 'CRUNCH_ENVIRONMENT'
    ComponentDir = os.path.split(component_wrapper)[0]
    QueueFilesDir =  os.path.split(commandfile)[0]
    stderrpath = os.path.join(QueueFilesDir, 'job.stderr')
    stdoutpath = os.path.join(QueueFilesDir, 'job.stdout')


    #extract name of job
    f = open(commandfile)
    l = f.readline()
    f.close()
    jobname = l.strip().split('=')[1]

    ## without memory monitoring (default):
    timestats = '-f \"# Real time                       : %E\\n# User time                       : %U\\n# Percent of CPU this job got     : %P\"'

    jobFileContent = '\n'.join([
        '#! /bin/bash',
        '#SBATCH -n %i' %int(n_nodes), # number of cpus
        '#SBATCH --mem=%s' %mem_limit, 
        '#SBATCH --time=%s' %time_limit,
        '#SBATCH -e %s' %stderrpath,
        '#SBATCH -o %s' %stdoutpath,
        '#SBATCH --job-name=%s' %jobname,
        '#SBATCH --workdir=%s' %ComponentDir,
        'export PYTHONPATH=%s' %os.environ['PYTHONPATH'], # for anduril to find its components
        'source %s' %crunch_env,
        '/usr/bin/time %s python %s %s' %(timestats, component_wrapper, commandfile)
    ])

    shellFilename = os.path.join(QueueFilesDir, 'command.sh')
    with open(shellFilename, 'w') as outf:
        outf.write(jobFileContent)


    T1 = datetime.datetime.now()
    print T1
    sys.stdout.flush()

    ## submit job                                                                                                                                                                                               
    sub_message = subprocess.check_output(["sbatch", shellFilename])
    # Submitted batch job 4014401                                                                                                                                                                               
    jobid = sub_message.split()[-1]
    job_finished = False

    print 'submitted', jobid
    sys.stdout.flush()

    ## wait until job finished                                                                                                                                                                                  
    wait_time = 30
    for x in range(12000):
        time.sleep(wait_time)
        # scontrol show jobid -dd 4014401                                                                                                                                                                       
        p = subprocess.Popen(["scontrol", "show", "jobid",
                            "-dd", jobid], stdin=subprocess.PIPE,
                             stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        qstat_message, error = p.communicate()
        if "JobState=RUNNING" not in qstat_message and "JobState=PENDING" not in qstat_message:
            job_finished = True
            time.sleep(wait_time)
            break

    if not job_finished:
        raise Exception("Your job is running for too long. Exiting.")
    else:
        print 'Job: ' + str(jobid) + ' finished with success.'
    

    print 'stdout:'
    sys.stdout.flush()
    os.system('cat %s' %stdoutpath)

    print 'stderr:'
    sys.stdout.flush()
    os.system('cat %s' %stderrpath)

    T2 = datetime.datetime.now()
    print T2
    print 'Running Time for %s: %s' %(jobname, str(T2-T1))
    sys.stdout.flush()


