#!/import/wnz/home/mara/local/bin/python
#/import/bc2/home/nimwegen/GROUP/local/bin/python
#/usr/bin/env python

import sys, os
import yaml
from string import *
import argparse
import subprocess
import smtplib
from email.mime.text import MIMEText

def extractFileType(f):

    t = None

    if f.endswith('.fastq.gz'):
        t = 'fastq'
    elif f.endswith('.fastq'):
        t = 'fastq'
    elif f.endswith('.fq.gz'):
        t = 'fastq'
    elif f.endswith('fq'):
        t = 'fastq'
    elif f.endswith('.fasta.gz'):
        t = 'fasta'
    elif f.endswith('.fasta'):
        t = 'fasta'
    elif f.endswith('.fa.gz'):
        t = 'fasta'
    elif f.endswith('.fa'):
        t = 'fasta'
    elif f.endswith('.bed.gz'):
        t = 'bed'
    elif f.endswith('.bed'):
        t = 'bed'

    return t

def change_permissions():

    # change permissions
    proc = subprocess.Popen('chmod -R a+w g+w .',
                            stdout=subprocess.PIPE,
                            stderr=subprocess.PIPE,
                            shell=True)

    stdout_value, stderr_value = proc.communicate()


def main():

    parser = argparse.ArgumentParser(description='Run Crunch.')
    parser.add_argument('-fg', dest='fg', action='store', required=True, help='Space separated string of foreground files')
    parser.add_argument('-bg', dest='bg', action='store', required=True, help='Space separated string of background files')
    parser.add_argument('-a3', dest='adaptor', action='store', required=False, help='3\' adaptor sequence')
    parser.add_argument('-g', dest='genome', action='store', required=True, help='genome')
    parser.add_argument('-fgwin', dest='fg_win', action='store', required=True, help='FG window size')
    parser.add_argument('-bgwin', dest='bg_win', action='store', required=True, help='BG window size')
    parser.add_argument('-step', dest='step_win', action='store', required=True, help='window step size')
    parser.add_argument('-mf', dest='motiffinding', action='store', required=True, help='motif finding yes or no (1 or 0)')
    parser.add_argument('-fdr', dest='fdr', action='store', required=True, help='False discovery rate used for peak calling')
    parser.add_argument('-email', dest='user_email', action='store', required=False, help='e-mail address of the user')

    args = parser.parse_args()

    scripts_dir = os.path.split(os.path.realpath(__file__))[0]
    templates_path = os.path.join(os.path.split(scripts_dir)[0], 'templates')
    configuration_path = os.path.join(os.path.split(scripts_dir)[0], 'config_web')

    params_template = os.path.join(configuration_path, 'params_%s.yaml' %(args.genome))

    python_path = '/import/wnz/home/mara/local/bin/python'

    # load yaml template
    cf = open(params_template)
    params = yaml.load(cf)

    # given on web site:
    fg_files = args.fg.split()
    bg_files = args.bg.split()

    if args.motiffinding == '1':
        params['DO_MOTIF_FINDING'] = True
    else:
        params['DO_MOTIF_FINDING'] = False

    try:
        adaptor = args.adaptor
    except AttributeError:
        adaptor = False

    for f in fg_files:
        t = extractFileType(f)

        if t == 'fastq':
            try:
                params['IP_FASTQ_FILES']['IP'] += f + ' '
            except TypeError:
                params['IP_FASTQ_FILES'] = {}
                params['IP_FASTQ_FILES']['IP'] = f + ' '
        if t == 'fasta':
            try:
                params['IP_FASTA_FILES']['IP'] += f + ' '
            except TypeError:
                params['IP_FASTA_FILES'] = {}
                params['IP_FASTA_FILES']['IP'] = f + ' '
        if t == 'bed':
            try:
                params['IP_BED_FILES']['IP'] += f + ' '
            except TypeError:
                params['IP_BED_FILES'] = {}
                params['IP_BED_FILES']['IP'] = f + ' '

    for f in bg_files:
        t = extractFileType(f)

        if t == 'fastq':
            try:
                params['BG_FASTQ_FILES'] += f + ' '
            except TypeError:
                params['BG_FASTQ_FILES'] = f + ' '
        if t == 'fasta':
            try:
                params['BG_FASTA_FILES'] += f + ' '
            except TypeError:
                params['BG_FASTA_FILES'] = f + ' '
        if t == 'bed':
            try:
                params['BG_BED_FILES'] += f + ' '
            except TypeError:
                params['BG_BED_FILES'] = f + ' '


    if adaptor:
        params['ADAPTOR'] = adaptor

    params['FDR'] = args.fdr
    params['WINDOW'] = args.fg_win
    params['BACKGROUND_WINDOW'] = args.bg_win
    params['STEP'] = args.step_win

    o = open('p.yaml', 'w')
    o.write(yaml.dump(params))
    o.close()

    with open(os.path.join(os.path.split(os.path.split(fg_files[0])[0])[0], 'project')) as f:
        pname = f.readline().strip()

    # email stuff:
    s = smtplib.SMTP('localhost')
    me = 'severin.berger@stud.unibas.ch'
    you = 'severin.berger@stud.unibas.ch'
    msg = MIMEText('User e-mail address: %s\nWorking Directory: %s\nGiven parameters: %s\n' %(args.user_email, os.getcwd(), args))
    msg['From'] = me
    msg['To'] = you

    try:
        msg['Subject'] = 'CRUNCH data submitted, \"%s\"' %pname
        s.sendmail(me, [you], msg.as_string())
        s.quit()
    except Exception, e:
        print 'email send failed:'
        print e
        pass


    print 'Setting up CRUNCH:'
    proc = subprocess.Popen('%s %s/run_Pipeline.py p.yaml' %(python_path, scripts_dir),
                            stdout=subprocess.PIPE,
                            stderr= subprocess.PIPE,
                            shell=True)

    stdout_value, stderr_value = proc.communicate()

    if proc.poll() > 0:
        print stdout_value
        print stderr_value
        print 'CRUNCH set up failed:\n'

        s = smtplib.SMTP('localhost')
        msg = MIMEText('Working Directory: %s\nUser e-mail address: %s' %(os.getcwd(), args.user_email))
        msg['From'] = me
        msg['To'] = you
        msg['Subject'] = 'CRUNCH set up failed, \"%s\"' %pname
        s.sendmail(me, [you], msg.as_string())
        s.quit()

        change_permissions()

        sys.exit(1)
    else:
        print 'CRUNCH set up successfully.\n'



    cs = open('andurilCOMMAND').readlines()
    sourceC = cs[1].strip()
    andurilC = cs[4].strip()

    # load environment variables
    crunch_env = os.path.join(configuration_path, 'crunch.env')
    env_dict = {}
    for line in open(crunch_env):
        if line.strip() and not line.startswith('#'):
            t = line.strip().split()[1].split('=')
            env_dict[t[0]] = t[1]

    print 'Environment variables:'
    print env_dict

    # Run CRUNCH
    print '\nRunning CRUNCH:'
    print andurilC + '\n'

    proc = subprocess.Popen(andurilC + ' > crunch_log', 
                            stdout=subprocess.PIPE,
                            stderr=subprocess.PIPE,
                            shell=True,
                            env=env_dict)

    stdout_value, stderr_value = proc.communicate()

    if proc.poll() > 0:
        print 'Pipe-line failed:\n'
        print stderr_value
        print stdout_value
        os.system('grep ERROR crunch_log')

        s = smtplib.SMTP('localhost')
        msg = MIMEText('Working Directory: %s\nUser e-mail address: %s' %(os.getcwd(), args.user_email))
        msg['From'] = me
        msg['To'] = you
        msg['Subject'] = 'CRUNCH execution failed, \"%s\"' %pname
        s.sendmail(me, [you], msg.as_string())
        s.quit()

        change_permissions()
        sys.exit(1)
    else:
        print 'Pipe-Line ran successfully.\n'


    # Create Report
    print 'Create CRUNCH report:'
    proc = subprocess.Popen('%s %s/make_output.py p.yaml' %(python_path, scripts_dir),
                            stdout=subprocess.PIPE,
                            stderr=subprocess.PIPE,
                            shell=True,
                            env=env_dict)

    stdout_value, stderr_value = proc.communicate()

    if proc.poll() > 0:
        print 'CRUNCH report creation failed:\n'
        print stdout_value
        print stderr_value

        s = smtplib.SMTP('localhost')
        msg = MIMEText('Working Directory: %s\nUser e-mail address: %s' %(os.getcwd(), args.user_email))
        msg['From'] = me
        msg['To'] = you
        msg['Subject'] = 'CRUNCH report creation failed, \"%s\"' %pname
        s.sendmail(me, [you], msg.as_string())
        s.quit()

        change_permissions()
        sys.exit(1)
    else:
        print 'CRUNCH report creation successful:\n'
        print stdout_value
        print stderr_value

    report_page = os.path.join('crunch.unibas.ch/CRUNCH/scratch', os.path.split(os.getcwd())[1])

    s = smtplib.SMTP('localhost')
    msg = MIMEText('Working Directory: %s\nUser e-mail address: %s\nResults page: %s/report_IP' %(os.getcwd(), args.user_email, report_page))
    msg['From'] = me
    msg['To'] = you
    msg['Subject'] = 'Crunch project \"%s\" has finished successfully' %pname
    s.sendmail(me, [you], msg.as_string())
    s.quit()

    s = smtplib.SMTP('localhost')
    msg = MIMEText('Dear Crunch user,\nYour data was analysed. You may find the results at %s/report_IP.\nFor questions, please contact %s\n\nThank you for using Crunch.\n\nYour Crunch Team' %(report_page, me))
    msg['From'] = me
    msg['To'] = args.user_email
    msg['Subject'] = 'Crunch project \"%s\" has finished' %pname
    s.sendmail(me, [args.user_email], msg.as_string())
    s.quit()

    change_permissions()

if __name__ == '__main__':
    main()
