#!/usr/bin/env python
import component_skeleton.main
import subprocess
import re, os, sys
from string import *
from datetime import datetime

def execute(cf):
    #in_dir = cf.get_input("in_dir")
    desc_dir = cf.get_input("desc_dir")
    out_dir = cf.get_output("out_dir")
    logfile = cf.get_output("extractWig_log")
    FMIid = cf.get_parameter("FMIid", "string")
    annoType = cf.get_parameter("annoType","string")
    mismatches = cf.get_parameter("mismatches", "int")
    width = cf.get_parameter("width", "int")
    FMIpath = cf.get_parameter("FMIpath", "string")
    FMI_output_dir = cf.get_parameter("FMI_output_dir", "string")

    T1 = datetime.now()

    os.system("mkdir %s" % (out_dir))

    outfile = os.path.join(out_dir, ''.join([FMIid, '.', annoType, '.w', str(width), '.m', str(mismatches), '.wig']))

    command1 = ' '.join(['perl',
                         FMIpath+'/soft/extractData.pl',
                         FMIid,
                         annoType,
                         'genome',
                         FMI_output_dir,
                         '-f'])

    command2 = ' '.join([FMIpath+'/soft/frag2wig.pl',
                         '- -m %d' %mismatches,
                         '-n %s' %FMIid,
                         '-w %d' %width,
                         '| gzip -9 > %s.gz' %outfile 
                         ])


    print 'Extracting %s\n' %FMIid

    p1 = subprocess.Popen(command1,
                          stdout=subprocess.PIPE,
                          shell=True)

    p2 = subprocess.Popen(command2,
                          stdin=p1.stdout,
                          stdout=subprocess.PIPE,
                          stderr=subprocess.PIPE,
                          shell=True)

    p1.stdout.close()
    stdout_value, stderr_value = p2.communicate()

    print 'p2 returncode', p2.returncode, p2.poll()
    print 'p1 returncode', p1.returncode, p1.poll()

    print stdout_value
    print stderr_value

    if p2.poll() > 0:
        print 'p2 failed'
        return -1
    if p1.poll() > 0:
        print 'p1 failed'
        return -1


    T2 = datetime.now()
    time = 'Running time for wig extraction: ' + str(T2-T1) + '\n'
    lf = open(logfile, 'a')
    lf.write(time)
    lf.close

    return 0


component_skeleton.main.main(execute)
