#!/usr/bin/env python

import fileinput

def its_plus(curr_plus, curr_minus, pending_plus, pending_minus, l):

    if int(l[1]) == curr_plus[1]:
        curr_plus[4] += float(l[4])
    else:
        if not curr_plus[0] == 'None': # only used for the first read
            if curr_plus[1] <= curr_minus[2]: # write it when it is lower or equal than current minus read, else pend it
                print '\t'.join(map(str, curr_plus))

                # and print the pending minus reads
                for p in pending_minus:
                    print '\t'.join(map(str, p))
                pending_minus = []

            else:
                pending_plus.append(curr_plus)

        curr_plus = [l[0], int(l[1]), int(l[1])+1, '.', float(l[4]), l[5]]

    return curr_plus, pending_plus, pending_minus


def its_minus(curr_plus, curr_minus, pending_plus, pending_minus, l):
    # nearly identical to its_plus, but for minus

    if int(l[2]) == curr_minus[2]:
        curr_minus[4] += float(l[4])
    else:
        if not curr_minus[0] == 'None':
            if curr_minus[2] <= curr_plus[1]:
                print '\t'.join(map(str, curr_minus))

                for p in pending_plus:
                    print '\t'.join(map(str, p))
                pending_plus = []

            else:
                pending_minus.append(curr_minus)

        curr_minus = [l[0], int(l[2])-1, int(l[2]), '.', float(l[4]), l[5]]

    return curr_minus, pending_plus, pending_minus


def main():
    """
    This codes reads from stdin.
    Input data need to be sorted by 5' ends (pioSortBed9 -s5).
    For reads starting at the same position (same 5' end) weights in 5th column get summed.
    For + strand reads I print chrom, read_start, read_start +1, ., strand
    For - strand reads I print chrom, read_end-1, read_end, ., strand
    Output is again sorted by 5' end.

    Stuff like this is a problem:
    chr1    10330   10331   .       0.592592592593  +
    chr1    10329   10330   .       0.142857142857  -
    chr1    10330   10331   .       0.0940170940171 +
    chr1    10329   10330   .       0.10989010989   -
    chr1    10330   10331   .       0.544289645683  +
    chr1    10329   10330   .       0.142857142857  -

    A solution:
    Always keep 2 lines in memory, one for plus and one for minus strand (curr_plus and curr_minus).
    Only write the line if the next line of the same strand is further down the chromosome, i.e. not the same position.

    Also pend reads if they would get written before the reads of the other strand that have lower coordinates.
    This happens in cases like this:
    chr1    10330   10331   .       0.592592592593  +
    chr1    10329   10330   .       0.142857142857  -
    chr1    10330   10331   .       0.0940170940171 +
    chr1    10329   10330   .       0.10989010989   -
    chr1    10330   10331   .       0.544289645683  +
    chr1    10331   10332   .       0.544289645683  +
    chr1    10332   10333   .       0.544289645683  +
    chr1    10329   10330   .       0.142857142857  -

    Here
    chr1    10331   10332   .       0.544289645683  +
    would be printed before
    chr1    10329   10330   .       0.142857142857  -
    So I just pend chr1_10331 until the chr1_10329 gets printed.
    """

    curr_chrom = 'None'

    for line in fileinput.input():

        l = line.strip().split()

        # I do one chromosome at a time. If a new one comes up I finish the old one...
        if not l[0] == curr_chrom:
            if not curr_chrom == 'None':
                if curr_minus[2] < curr_plus[1]:
                    if not curr_minus[0] == 'None':
                        print '\t'.join(map(str, curr_minus))
                        for p in pending_plus:
                            print '\t'.join(map(str, p))

                    if not curr_plus[0] == 'None':
                        print '\t'.join(map(str, curr_plus))
                        for p in pending_minus:
                            print '\t'.join(map(str, p))

                else:
                    if not curr_plus[0] == 'None':
                        print '\t'.join(map(str, curr_plus))
                        for p in pending_minus:
                            print '\t'.join(map(str, p))

                    if not curr_minus[0] == 'None':
                        print '\t'.join(map(str, curr_minus))
                        for p in pending_plus:
                            print '\t'.join(map(str, p))


            curr_chrom = l[0]
            curr_plus = ['None', 1000000000 , 1000000000, '.', 0.0, '+']
            curr_minus = ['None', 1000000000 , 1000000000, '.', 0.0, '-']

            pending_plus = []
            pending_minus = []


        if l[5] == '+':
            curr_plus, pending_plus, pending_minus = its_plus(curr_plus, curr_minus, pending_plus, pending_minus, l)

        else:
            curr_minus, pending_plus, pending_minus = its_minus(curr_plus, curr_minus, pending_plus, pending_minus, l)


    # finish things up
    if curr_minus[2] < curr_plus[1]:
        if not curr_minus[0] == 'None':
            print '\t'.join(map(str, curr_minus))
            for p in pending_plus:
                print '\t'.join(map(str, p))

        if not curr_plus[0] == 'None':
            print '\t'.join(map(str, curr_plus))
            for p in pending_minus:
                print '\t'.join(map(str, p))

    else:
        if not curr_plus[0] == 'None':
            print '\t'.join(map(str, curr_plus))
            for p in pending_minus:
                print '\t'.join(map(str, p))

        if not curr_minus[0] == 'None':
            print '\t'.join(map(str, curr_minus))
            for p in pending_plus:
                print '\t'.join(map(str, p))



if __name__ == '__main__':
    main()
