#!/usr/bin/env python
import component_skeleton.main
import subprocess
import re, os, sys
from string import *
from datetime import datetime
import shutil

def execute(cf):
    #in_dir = cf.get_input("in_dir")
    out_dir = cf.get_output("out_dir")
    error_profiles_plot = cf.get_output("error_profiles_plot")
    fraction_aligned_plot = cf.get_output("fraction_aligned_plot")
    repeatedness_plot = cf.get_output("repeatedness_plot")
    logfile = cf.get_output("createErrorPlots_log")
    FMIid = cf.get_parameter("FMIid", "string")
    annoType = cf.get_parameter("annoType","string")
    FMIpath = cf.get_parameter("FMIpath", "string")
    FMI_output_dir = cf.get_parameter("FMI_output_dir", "string")

    T1 = datetime.now()

    os.mkdir(out_dir)

    ##change present working directory to out_dir. Otherwise .Rout files get stored in component's directory
    pwd = os.getcwd()
    os.chdir(out_dir)

    outfile = os.path.join(out_dir, FMIid)

    command1 = ' '.join(['perl',
                         FMIpath+'/soft/extractData.pl',
                         FMIid,
                         annoType,
                         'genome',
                         FMI_output_dir,
                         '-f'])

    command2 = ' '.join([FMIpath+'/soft/createErrorPlots.pl',
                         '- %s -o %s' %(FMI_output_dir, outfile)])

    p1 = subprocess.Popen(command1,
                          stdout=subprocess.PIPE,
                          shell=True)

    p2 = subprocess.Popen(command2,
                          stdin=p1.stdout,
                          stdout=subprocess.PIPE,
                          stderr=subprocess.PIPE,
                          shell=True)

    p1.stdout.close()
    stdout_value, stderr_value = p2.communicate()

    print 'p2 returncode', p2.returncode, p2.poll()
    print 'p1 returncode', p1.returncode, p1.poll()

    print stdout_value
    print stderr_value

    if p2.poll() > 0:
        print 'p2 failed'
        return -1
    if p1.poll() > 0:
        print 'p1 failed'
        return -1


    #/import/bc2/soft/bin/R CMD BATCH
    proc2 = subprocess.Popen ('R CMD BATCH ' + outfile + '.R',
                              stdout=subprocess.PIPE,
                              stderr=subprocess.PIPE,
                              shell=True
                              )

    stdout_value2, stderr_value2 = proc2.communicate()
    print 'R STDOUT: ', stdout_value2
    print 'R STDERR: ', stderr_value2
    if proc2.poll() > 0:
        print '\tstderr:', repr(stderr_value2.rstrip())
        return -1	

    shutil.copyfile(outfile + '-error_profiles.pdf', error_profiles_plot)
    shutil.copyfile(outfile + '-fraction_aligned.pdf', fraction_aligned_plot)
    shutil.copyfile(outfile + '-repeatedness.pdf', repeatedness_plot)

    os.chdir(pwd)

    T2 = datetime.now()
    time = 'Running time for creating error plots: ' + str(T2-T1) + '\n'
    lf = open(logfile, 'a')
    lf.write(time)
    lf.close	

    return 0

component_skeleton.main.main(execute)
