#!/usr/bin/env python
import component_skeleton.main
import subprocess
import os
from datetime import datetime

def execute(cf):
    infile = cf.get_input("in_file")
    out_dir = cf.get_output("out_dir")
    outfile = cf.get_output("outfile")
    plotfile = cf.get_output("Z_hist")
    logfile = cf.get_output("log_file")

    T1 = datetime.now()

    os.mkdir(out_dir)

    print 'fit sigma mu rho'

    command = 'perl fit_sigma_mu_rho_sum_replicates_Erik.pl %s %s %s' % (infile, out_dir, plotfile)

    proc = subprocess.Popen(command,
                            stdout=subprocess.PIPE,
                            stderr= subprocess.PIPE,
                            shell=True)

    stdout_value, stderr_value = proc.communicate()
    print stdout_value
    print stderr_value

    if proc.poll() > 0:
        print '\tstderr:', repr(stderr_value.rstrip())
        return -1

    # gzip and move to actual output file
    os.system('gzip %s/outzvals && mv %s/outzvals.gz %s ' %(out_dir, out_dir, outfile))

    #add stats file (fitted mu, sigma and rho) to log_file
    f = open(os.path.join(out_dir, 'stats_get_zvals'))
    text = f.read()
    f.close()

    T2 = datetime.now()
    time = 'Running time for peak caller: ' + str(T2-T1) + '\n'
    lf = open(logfile, 'w')
    lf.write(text)
    lf.close

    return 0

component_skeleton.main.main(execute)
