#!/usr/bin/env python

import anduril
from anduril.args import infile, mappings, overmapped, unmapped, threads, bowtie_path, index_path
import subprocess, os


def main():
    """
    -v maximum number of mismatches allowed per read
    -m maximum number of hits
    --best --strata report all alignments of the best strata where starta are the alignments with the least errors/mismatches.
    """

    # ../../new_bowtie/bowtie-1.1.1/bowtie -f -p 32 -v 3 -a -B 1 -m 100 --quiet --best --strata --max seqsOver100.fa --un seqsUnmapped.fa ../../crunch_dev/fmitools/DB/genomes/hg19/bowtieIndex/bowtieIndex OUTPUT/BG_1-trans/out_file > BG_1_mapping.bowtie

    
    options = '-f -p %i -v 3 -a -B 1 -m 100 --quiet --best --strata' %threads

    # check whether to use zcat or cat. less uses too much memory and is not that efficient.
    if infile.endswith('.gz'):
        cat_prog = 'zcat'
    else:
        cat_prog = 'cat'

    command = ' '.join([cat_prog,
                        infile,
                        '|',
                        bowtie_path,
                        options,
                        '--max %s' %overmapped,
                        '--un %s' %unmapped,
                        index_path,
                        '- | gzip >', # read from stdin
                        mappings])

    proc = subprocess.Popen(command,
                            stdout=subprocess.PIPE,
                            stderr=subprocess.PIPE,
                            shell=True) 
    
    stdout_value, stderr_value = proc.communicate()
    print stdout_value
    print stderr_value

    if proc.poll() > 0:
        print '\tstderr:', repr(stderr_value.rstrip())
        return -1

    if not os.path.isfile(overmapped):
        os.system('touch %s' %overmapped)

    if not os.path.isfile(unmapped):
        os.system('touch %s' %unmapped)

    return 0

main()
