#!/usr/bin/env python

import sys
import os
from string import *
from pylab import *


def get_co(x, y, outroot, default_co):

    figure()

    #to make a stable analysis, sample the data linearly spaced in x
    size = 1000
    xn = linspace(max(1,min(x)), min(10000, max(x)), size)
    yn = []

    for xi in xn:
        yidx = argmin(abs(x-xi))
        yn.append(y[yidx])

    x = array(xn)
    y = array(yn)

    # dydx = [y[i+1]-y[i] for i in arange(len(y)-1)]
    # mx = [mean([x[i], x[i+1]]) for i in arange(len(x)-1)]
    # plot(mx,dydx)

    xlim([0, min(1000, max(x))])
    ylim([min(y), max(y)+1])
    plot(x,y)

    # 1. find linear fit at the beginning of the curve. Take first 100 data points
    # r1 = size/3
    # X = vstack([x[:r1], np.ones(len(x[:r1]))]).T
    # params = lstsq(X, y[:r1])

    # fx1 = x*params[0][0]+params[0][1]

    # more save to just take a line with slope 0
    fx1 = x*0.0+max(y)
    plot(x,fx1)

    savefig('%s.pdf' %(os.path.join(outroot, 'co-fit'))) # intermediate save of plot

    # 2. compute deviation from linear fit and actual y to find the point where actual y goes down
    dy = fx1 - y
    idx1 = where(dy>2)[0][0]
    plot([x[idx1], x[idx1]], [0,max(y)])

    # 3. fit a second line from this index on. Try to find the steepest line in some region
    slopes = []
    inters = []
    r2s = []

    minslope = 10
    for i in arange(size/50,size/5, 1):

        r2 = i

        X = vstack([x[idx1:idx1+r2], np.ones(len(x[idx1:idx1+r2]))]).T
        params = lstsq(X, y[idx1:idx1+r2])

        fx2 = x*params[0][0]+params[0][1]
        slope_return = params[0][0]
        intercept_return = params[0][1]

        slopes.append(params[0][0])
        inters.append(params[0][1])

        #compute R**2
        sstot = sum((y[idx1:idx1+r2] - mean(y[idx1:idx1+r2]))**2)
        sserr = sum((y[idx1:idx1+r2] - (params[0][0] * x[idx1:idx1+r2] + params[0][1]))**2)

        #coefficient of determination
        rsq = 1 - (sserr/sstot)
        r2s.append(rsq)

    # binvars = []
    # bins = linspace(0,size,100)
    # for i in arange(len(bins)-1):
    #     binvars.append(var(y[bins[i]:bins[i+1]]))

    # print binvars

    # R2 always decreases... Thus not useful
    # rsq_idx = argmin(r2s)
    # slope = slopes[rsq_idx]
    # inte = inters[rsq_idx]
    # upperb = arange(2,size/5, 1)[rsq_idx]

    slope = min(slopes)
    inte = inters[argmin(slopes)]
    upperb = arange(2,size/5, 1)[argmin(slopes)]

    # slope = mean(slopes)
    # slope_idx = argmin(abs(array(slopes)-slope))
    # inte = inters[slope_idx]
    # upperb = arange(2,size/5, 1)[slope_idx]

    fx2 = x*slope+inte

    plot(x, fx2)
    plot([x[idx1+upperb], x[idx1+upperb]], [0,max(y)])
    plot(x[idx1:idx1+upperb],fx2[idx1:idx1+upperb])

    savefig('%s.pdf' %(os.path.join(outroot, 'co-fit'))) # intermediate save of plot

    # 3. again compute deviation
    dy2 = fx2 - y

    #find the point, where all values following deviate more than -0.5 from the fitted line
    start_idx = upperb
    i = 1
    while 1:
        i += 1
        if i == 10:
            co = default_co
            return co

        dev = -0.5 # if I make this too small it can give bad results if fit is not that great
        try:
            idx2 = where(dy2[where(x >= x[idx1+start_idx])] <= dev)[0][0]
        except IndexError:
            print 'Could not estimate cut-off automatically. Default cut-off %s used.' %default_co
            co = default_co
            return co

        #if len(dy2[where(dy2[where(x >= x[idx1+start_idx])] > -0.5)]) != 0:
        if len( where(dy2[where(x >= x[idx1+start_idx+idx2])] > dev) ) != 0:
            start_idx += idx2
            break
        else:
            start_idx += idx2
            continue


    print i
    #idx2 = where(dy2[where(x >= x[idx1+upperb])] <= -0.5)[0][0]

    #co = x[idx2 + idx1 + upperb] #cut-off has to be higher than upperb... makes it more stable

    co = x[idx1 + start_idx] #cut-off has to be higher than upperb... makes it more stable

    plot([co,co],[0,12], label='cut-off: %.3f' %co)

    legend()
    savefig('%s.pdf' %(os.path.join(outroot, 'co-fit')))

    return int(exp(co))


def main():

    infile = sys.argv[1]
    interm = sys.argv[2]
    outplot = sys.argv[3]
    cofile = sys.argv[4]
    bgnum = int(sys.argv[5])

    bgcols = arange(bgnum) + 1
    bgcols *= -1

    # load Z-values to plot and get Z-cutoff. loadtxt does also read from gzipped files.
    a = loadtxt(infile, usecols=bgcols[::-1], skiprows=1)
    if bgnum > 1:
        a = sum(a, axis=1)
    x = array(sorted(a))
    y = log(arange(1, len(x)+1, 1))[::-1]

    default_co = mean(a) + 3*std(a)

    co = get_co(log(x), y, interm, default_co)
    co = round(co, 2)

    # plot reverse cumulative
    figure()
    plot(x,y, 'k')
    plot([co, co], [min(y), max(y)], 'r', label='chosen cut-off %s' %co)
    xlim([0,min(max(3*co,100), max(x))])
    ylim(0,int(max(y)+1))
    xlabel("Read Density")
    ylabel("log(Number of Background Windows)")
    legend()
    title('Reverse Cumulative Distribution of Background Read Counts')
    savefig(outplot)
    savefig(outplot.rstrip('.pdf'))
    close()


    o = open(cofile, 'w')
    o.write(str(co))
    o.close()


    return 0


if __name__ == "__main__":
    main()
