#!/usr/bin/env python

import sys, os
import fileinput

def main():
    """
    tranform component gives a unique fasta file that contains the copy number of each read in the header.
    This is the input that should be used by bowtie.
    The output of bowtie then looks like:

    FC30P42HM_20081212:6:3:487:1935 1       +       chr2    151774464       AGGAAAAAAGGCTTTGTTTTTGTGCAAA    IIIIIIIIIIIIIIIIIIIIIIIIIIII    0       
    FC30P42HM_20081212:6:29:245:121 1       -       chr16   2584251 CAGCTATAAGGTCAGCTGATTAATT       IIIIIIIIIIIIIIIIIIIIIIIII       0       
    FC30P42HM_20081212:6:50:519:804 1       +       chr3    82943025        GAGACAGACAGAGAGAACGAAAGAGACA    IIIIIIIIIIIIIIIIIIIIIIIIIIII    2       17:A>C
    FC30P42HM_20081212:6:50:519:804 1       +       chr1    195109400       GAGACAGACAGAGAGAACGAAAGAGACA    IIIIIIIIIIIIIIIIIIIIIIIIIIII    2       17:A>C
    FC30P42HM_20081212:6:50:519:804 1       -       chrUn_gl000220  127285  TGTCTCTTTCGTTCTCTCTGTCTGTCTC    IIIIIIIIIIIIIIIIIIIIIIIIIIII    2       0:G>C
    FC30P42HM_20081212:6:61:1007:1744 1     +       chr2    162965671       GTTTCAGGCCATGGGTCAAGCAGCAT      IIIIIIIIIIIIIIIIIIIIIIIIII      0       
    FC30P42HM_20081212:6:8:179:451 1        -       chrX    123143603       AGGTTTCAATGACAGTTTTCATACTCTA    IIIIIIIIIIIIIIIIIIIIIIIIIIII    0       
    FC30P42HM_20081212:6:10:352:1947 2      -       chr4    94645692        ATGTAATTTCTCTTCTCTATGTCCTTC     IIIIIIIIIIIIIIIIIIIIIIIIIII     0       
    FC30P42HM_20081212:6:59:1174:1599 1     -       chr4    15142400        GTCCTCAGTCCTGCATTTATGCCTTTTC    IIIIIIIIIIIIIIIIIIIIIIIIIIII    0     


    1. column: read name (== fasta header)
    2. column: strand
    3. column: chrom
    4. column: start (0 based indexing)
    5. column: read sequence (not alignment sequence!). If aligned to - strand it is the reverse complement
    6. column: Quality score
    7. column: n+1 is the number of positions the read mapped to.
    8. column: in case there were mismatches they are reported here.

    To extract bedweight format weight each mapping with copy_numer/mappings, i.e.:
    (number in column 1) / ((number in column 7) + 1)
    """

    for line in fileinput.input():
        l = line.strip().split('\t')

        l0 = l[0].split(' ')
        read_name = l0[0]
        copy_num = float(l0[1])

        strand = l[1]
        chrom = l[2]
        start = int(l[3])
        end = start + len(l[4])

        mappings = float(l[6]) + 1

        print '\t'.join(map(str, [chrom, start, end, read_name, copy_num/mappings, strand]))


if __name__ == '__main__':
    main()
