#!/usr/bin/env python

import anduril
from anduril.args import infile, outfile, fmitools
import subprocess
import os

def main():
    """
    First bowtie to bedweight, then sorting, then collapsing
    """

    # check whether to use zcat or cat. less uses too much memory and is not that efficient.
    if infile.endswith('.gz'):
        cat_prog = 'zcat'
    else:
        cat_prog = 'cat'

    print infile
    print cat_prog

    command1 = ' '.join(['%s %s |' %(cat_prog, infile),
                         './bowtie2bedweight.py'])

    command2 = ' '.join([os.path.join(fmitools, 'soft/pioSortBed9'),
                         '-s5',
                         '--input-file -'])

    command3 = './collapse_bedweight.py'

    command4 = 'gzip > %s' %outfile

    p1 = subprocess.Popen(command1,
                          stdout=subprocess.PIPE,
                          shell=True)

    p2 = subprocess.Popen(command2,
                          stdin=p1.stdout,
                          stdout=subprocess.PIPE,
                          stderr=subprocess.PIPE,
                          shell=True)

    p3 = subprocess.Popen(command3,
                          stdin=p2.stdout,
                          stdout=subprocess.PIPE,
                          stderr=subprocess.PIPE,
                          shell=True)

    p4 = subprocess.Popen(command4,
                          stdin=p3.stdout,
                          stdout=subprocess.PIPE,
                          stderr=subprocess.PIPE,
                          shell=True)

    p1.stdout.close()
    p2.stdout.close()
    p3.stdout.close()
    stdout_value, stderr_value = p4.communicate()

    print 'p4 returncode', p4.returncode, p4.poll()
    print 'p3 returncode', p3.returncode, p3.poll()
    print 'p2 returncode', p2.returncode, p2.poll()
    print 'p1 returncode', p1.returncode, p1.poll()

    print stdout_value
    print stderr_value

    if p4.poll() > 0:
        print 'p4 failed'
        return -1
    if p3.poll() > 0:
        print 'p3 failed'
        return -1
    if p2.poll() > 0:
        print 'p2 failed'
        return -1
    if p1.poll() > 0:
        print 'p1 failed'
        return -1

    return 0


main()
