#!/usr/bin/env python

import sys, os

def main():
    """
    Create a WIG file from a bedweight file.
    WIG shows density of reads within some intervals of fixed size.

    - header of file:

    track type=wiggle_0 name='sample_name' description='sample description' visibility=full color=27,158,119 altColor=27,158,119 priority=100 autoscale=off gridDefault=on maxHeightPixels=128:128:11 graphType=bar yLineMark=0.0 yLineOnOff=off windowingFunction=maximum smoothingWindow=off

    - each chrom starts with header like this:

    variableStep chrom=chr1 span=100

    - span is the size of the genome intervals (here 100)

    Example:

    variableStep chrom=chr1 span=100
    1 0.00
    10101 0.20
    10201 0.59
    10301 0.19
    10401 0.18
    10501 0.02
    10601 0.00
    10701 0.01

    - Always start with 1 0.00
    - Next window shows the sum of read weights from 10101 till 10200


    Program reads BEDWEIGHT from stdin and writes WIG to stdout.
    """

    span = int(sys.argv[1])

    # print header
    print "track type=wiggle_0 name='sample_name' description='sample description' visibility=full color=27,158,119 altColor=27,158,119 priority=100 autoscale=off gridDefault=on maxHeightPixels=128:128:11 graphType=bar yLineMark=0.0 yLineOnOff=off windowingFunction=maximum smoothingWindow=off"


    chrom = ''
    for line in sys.stdin:

        l = line.strip().split()

        if not l[0] == chrom:
            # print last windows from last chrom
            if chrom:
                print '%i\t%f' %(curr_win, curr_weight)

            chrom = l[0]
            print "variableStep chrom=%s span=%i" %(chrom, span)

            curr_win = 1
            curr_weight = 0.0


        # take 5 prime end
        if l[5] == '+':
            start = int(l[1])
        else:
            start = int(l[2])

        weight = float(l[4])

        if start > curr_win + span:
            print '%i\t%f' %(curr_win, curr_weight)

            # update window
            while start > curr_win:
                curr_win += span

            curr_win -= span
            curr_weight = weight

        else:
            curr_weight += weight

    # print last window
    print '%i\t%f' %(curr_win, curr_weight)

if __name__ == '__main__':
    main()
