#!/usr/bin/env python

import anduril
from anduril.args import infile, outfile, span
import subprocess
import os

def main():
    """
    """

    # check whether to use zcat or cat. less uses too much memory and is not that efficient.
    if infile.endswith('.gz'):
        cat_prog = 'zcat'
    else:
        cat_prog = 'cat'

    command1 = '%s %s' %(cat_prog, infile)

    command2 = './bedweight2wig.py %i' %span

    command3 = 'gzip > %s' %outfile

    p1 = subprocess.Popen(command1,
                          stdout=subprocess.PIPE,
                          shell=True)

    p2 = subprocess.Popen(command2,
                          stdin=p1.stdout,
                          stdout=subprocess.PIPE,
                          shell=True)

    p3 = subprocess.Popen(command3,
                          stdin=p2.stdout,
                          stdout=subprocess.PIPE,
                          stderr=subprocess.PIPE,
                          shell=True)

    p1.stdout.close()
    p2.stdout.close()
    stdout_value, stderr_value = p3.communicate()

    print 'p3 returncode', p3.returncode, p3.poll()
    print 'p2 returncode', p2.returncode, p2.poll()
    print 'p1 returncode', p1.returncode, p1.poll()

    print stdout_value
    print stderr_value

    if p3.poll() > 0:
        print 'p3 failed'
        return -1
    if p2.poll() > 0:
        print 'p2 failed'
        return -1
    if p1.poll() > 0:
        print 'p1 failed'
        return -1

    return 0

main()
