



# set up new coordinates to calculate 500 bps surrounding the gene start site.
for(i in 1:nrow(genes.df)){
  if(genes.df$strand[i] == "-"){
  genes.df$net_start[i] <- genes.df$end[i] - 400
  genes.df$net_end[i] <- genes.df$end[i] + 100
  } else {
    genes.df$net_start[i] <- genes.df$start[i] - 100
    genes.df$net_end[i] <- genes.df$start[i] + 400
  }
}


file_name.bam = "netseq_merged.bam"
file_name.bam.bai = "netseq_merged.bam.bai"

for (m in 1:nrow(genes.df )){
  chr = (genes.df [m,"chr"])
  new_start= (genes.df [m, "net_start"])
  new_end= (genes.df [m, "net_end"])
  
  chr.gr = GRanges(seqnames= chr, ranges = IRanges(start =new_start , end = new_end ))
  
  p = ScanBamParam(what = c("rname", "strand", "pos", "qwidth"),which = chr.gr)
  
  A_reads.l = scanBam(file = file_name.bam,
                      index = file_name.bam.bai,
                      param = p)
  
  #create a new GenomicRanges object for the reads 
  A_reads.gr = GRanges(seqnames = A_reads.l[[1]]$rname,
                       ranges = IRanges(start = A_reads.l[[1]]$pos, 
                                        width = A_reads.l[[1]]$qwidth),
                       strand = A_reads.l[[1]]$strand)
  
  #calling the midpoints of the reads                          
  ranges(A_reads.gr) = IRanges(start=mid(ranges(A_reads.gr)), width=1)
  
  ss_data.df <- as.data.frame(A_reads.gr)
  
  C <-  (nrow(ss_data.df)) #Number of reads mapped to a gene
  
  genes.df$NET_seq[m] <-  C/500 
  
  cat("\t done with counts in gene",m ,"\n")
}

