
dens_vector = function(bam_name, pos, chrom, d_min, d_max, strand){

  #data files
  file_name.bam = paste(bam_name,".bam", sep='')
  file_name.bam.bai = paste(bam_name,".bam.bai",sep='')
  
  chr = chrom
  new_start= pos-2500
  new_end= pos+ 2500
  
  chr.gr = GRanges(seqnames= chr, ranges = IRanges(start =new_start , end = new_end ))
  
  p = ScanBamParam(what = c("rname", "strand", "pos", "isize"),which = chr.gr)
  
  A_reads.l = scanBam(file = file_name.bam,
                      index = file_name.bam.bai,
                      param = p)
  
  
  #create a new GenomicRanges object for the reads from this list:
  A_reads.gr = GRanges(seqnames = A_reads.l[[1]]$rname,
                       ranges = IRanges(start = A_reads.l[[1]]$pos,
                                        width = A_reads.l[[1]]$isize))
  
  subset_data.gr = A_reads.gr[which(width(A_reads.gr) > d_min & width(A_reads.gr)< d_max)]
  
  #obtaining read midpoints
  ranges(subset_data.gr) = IRanges(start=mid(ranges(subset_data.gr)), width=1)
  
  ss_data.df <- as.data.frame(subset_data.gr)
  
  for(i in 1:nrow(ss_data.df)){
    ss_data.df$dis[i] <-  ss_data.df$start[i] - pos
  }
  
  if(strand == "-"){
    ss_data.df$dis <- ss_data.df$dis * (-1)  
  } else {
    ss_data.df$dis <- ss_data.df$dis
  }

  (cat("\tready to append to density vector of", chrom, pos,"\n"))
  
 return(ss_data.df$dis)

  }
  

