
rm(list = ls())

## to find PTMs is each nucleosome 

library(Rsamtools)
library(GenomicRanges)

#settings 
file_name <- c('htz1','h2ak5ac','h3k14ac','h3k23ac','h3k27ac','h3k36me2',
               'h3k36me','h3k4ac','h3k4me2','h3k4me','h3k56ac','h3k79me',
               'h3k9ac','h3s10ph','h4k12ac','h4k16ac','h4k5ac','h4k8ac',
               'h4r3me2s','h4r3me','h3k36me3','h3k18ac','h3k4me3',
               'h4k20me','h3k79me3','h2as129ph')

dir_path <- "~/your-directory-path/"

for (m in 1:nrow(chr_nuc_ratios.df)){
  
  chr = (chr_nuc_ratios.df[m,"chr"])
  new_start= (chr_nuc_ratios.df[m, "nuc_peaks"])-70
  new_end= (chr_nuc_ratios.df[m, "nuc_peaks"]) +70
  
  chr.gr = GRanges(seqnames= chr, ranges = IRanges(start =new_start , end = new_end ))
  
  p = ScanBamParam(what = c("rname", "strand", "pos", "qwidth"),which = chr.gr)
  
  for(f in 1:length(file_name)){

    #data files
    file_name.bam = paste(dir_path,file_name[f],".bam", sep='')
    file_name.bam.bai = paste(dir_path,file_name[f],".bam.bai",sep='')
    
  A_reads.l = scanBam(file = file_name.bam,
                      index = file_name.bam.bai,
                      param = p)
  
  #All the information from the range is in the first entry of the output_reads.l list (this can be       accessed by ou$
  # str(output_reads.l[[1]]) to see list structure
  
  #create a new GenomicRanges object for the reads from this list:
  A_reads.gr = GRanges(seqnames = A_reads.l[[1]]$rname,
                       ranges = IRanges(start = A_reads.l[[1]]$pos, 
                                        width = A_reads.l[[1]]$qwidth),
                       strand = A_reads.l[[1]]$strand)
  
  #changing the genomic ranges so that it uses the midpoint instead of the length of the read.                          
  ranges(A_reads.gr) = IRanges(start=mid(ranges(A_reads.gr)), width=1)
  
  ss_data.df <- as.data.frame(A_reads.gr)
  
  C <-  nrow(ss_data.df) #Number of reads mapped to a nucleosome
  
  L <- 140 #length in base-pairs 
  
  nucs[m, filenames[f]] <-  C/L 
  
  cat("\t done with counts in nuc",m , "on file", file_name[f],"\n")
  }
  }

