library(Rsamtools)
library(GenomicRanges)

cuar <- quantile(abs(tfs$logratio))

#first and last decile
qt <-  quantile(tfs$logratio, seq(0,1, .10))

qt1 <- which(tfs$logratio < qt[2])
qt10 <- which(tfs$logratio > qt[10])

#finding the TFs that don't change 
st <- tfs[which(tfs$logratio < 1.1 & tfs$logratio > 0.9),]
st <- st[order(log2(st$Mreads+st$Nreads+1),decreasing = T),]

#TF subsets to plot 
s1 <- tfs[qt1,]
s2 <- tfs[qt10,]
s3 <- tfs[row.names(st),]

cl <- viridis(100, alpha = 1, begin = 0, end = 1, option = "C") 
n=  5
int = "dark grey" 
m=  50


htm.m = matrix(c(0.05, 1, 0.1, 1, #(x1, x2, y1, y2)
                 0.05, 1, 0.08, 0.1, #xlab
                 0.02, 0.04, 0.15, 1), #ylab
               ncol = 4, byrow = T)


htm_plot.s = split.screen(htm.m)

screen(htm_plot.s[1])

par(mar = c(2,2,2,2))  
plot(density(log2(s3$dis)),  col=int, main="",
     ylim=c(0,0.4), lwd=3, xaxt="n", xlim=c(4,14), 
     xlab="Distance from Gene Start Site")
lines(density(log2(s2$dis)),  col=cl[m], lwd=3)
lines(density(log2(s1$dis)),  col=cl[n], lwd=3)
axis(1, at=seq(4,14,2), labels = c(2^4, 2^6,2^8, 2^10,2^12, 2^14))

legtext <- c("Transient", "Slow", "Fast")
legend("topright" ,legend=legtext,  pt.bg =c(cl[n],cl[m],int), 
       pch=c(21,21,21), 
       col="black",
       pt.cex=1.5,cex=0.9,bty = "n", h=F, y.intersp=1.25, x.intersp=1)

screen(htm_plot.s[2])
par(mar=c(0,0,0,0))
mtext('Relative Distance From TSS', side = 1, cex=1)

screen(htm_plot.s[3])
par(mar=c(0,0,0,0))
mtext('Density Distribution', side = 2, cex=1)



