# Clear the workspace
graphics.off()
rm(list = ls())

##call functions
source('/figures/typhoon_plot_functions.R')

# Set the dir
subpanel_dir = "~/Figure5/"

tiff(file ="~/Figure5/Gutierrez_Fig5.tiff",height = 10, width = 10, units = "in", res = 800, compression = "lzw")

# Setup the screen
overall_scr.m = matrix(c(0.03, 0.43, 0.55, 1, #left, right, top, bottom (x1, x2, y1, y2)
                         0.45, 1, 0.55, 1,
                         0.03, 0.43, 0.16, 0.56, 
                         0.45, 1, 0.16, 0.56,
                         
                         0.01, 0.04, 0.96, 1,
                         0.42, 0.46, 0.96, 1,
                         0.01, 0.04, 0.52, 0.55,
                         0.42, 0.46, 0.52, 0.55,
                         0.03, 1, 0, 0.13
                         
),
ncol = 4, byrow = T
)

# Split the overall screen
close.screen(all.screens = T)

# Setup the screen
all_plots.s = split.screen(overall_scr.m)
par(oma = c(1, 1, 1, 1)) #bottom, left, top, right

# Panel A:
cat("\tMaking plot A\n")
screen(all_plots.s[1])
par(mai=c(0,0,0,0))
source(paste(subpanel_dir, "diff_heatmapTF_5A.R", sep = ""))

# Panel B:
cat("\tMaking plot B\n")
screen(all_plots.s[2])
par(mai=c(0,0,0,0))
source(paste(subpanel_dir, "nucs_dens_5C.R", sep = ""))


# Panel C:
cat("\tMaking plot C\n")
screen(all_plots.s[3])
par(mai=c(0,0,0,0))
source(paste(subpanel_dir, "TFs_dens_5B.R", sep = ""))

# Panel D:
cat("\tMaking plot D\n")
screen(all_plots.s[4])
par(mai=c(0,0,0,0))
source(paste(subpanel_dir, "occupancy_distr_subsets_5E.R", sep = ""))


screen(all_plots.s[5])
par(mai=c(0,0,0,0))
add_figure_label("A", label_cex_ratio = 0.8)

screen(all_plots.s[6])
par(mai=c(0,0,0,0))
add_figure_label("C", label_cex_ratio = 0.8)

screen(all_plots.s[7])
par(mai=c(0,0,0,0))
add_figure_label("B", label_cex_ratio = 0.8)

screen(all_plots.s[8])
par(mai=c(0,0,0,0))
add_figure_label("D", label_cex_ratio = 0.8)

screen(all_plots.s[9])
par(mar=c(0,0,0,0))
source(paste(subpanel_dir,"legend.R" , sep = ""))

mtext(expression(bold("Figure_5")), side =1, cex=1.25, outer=T, line = 0, adj = 0)

# Close all the screens
close.screen(all.screens = T)

# Close the device
dev.off()
