library(Rsamtools)
library(GenomicRanges)

##call functions
source('~/typhoon_plot_functions.R')

chr_subnuc_ratios.df <- read.csv('~/chr_subnuc_ratios.csv', stringsAsFactors=F) 

#subset on TFs with high confidence footprints 
tfs <- chr_subnuc_ratios.df[which((log2(chr_subnuc_ratios.df$Mreads) + log2(chr_subnuc_ratios.df$Nreads)) > 10),]


data=vector('list')

data[[1]] <- read.csv("~/Figure5/Nascent_footprint_matrix.csv")
data[[2]] <- read.csv("~/Figure5/Mature_footprint_matrix.csv")

##distance from a promoter. 
genes <-  read.csv("~/genes_master_table.csv", stringsAsFactors = F)

genes$pos <-NA
for(i in 1:nrow(genes)){
  if(genes$strand[i] == "-"){
    genes$pos[i] <- genes$end[i]
  } else {
    genes$pos[i] <- genes$start[i]
  }
}

for(i in 1:nrow(tfs)){
  gs <- genes[which(genes$chr == tfs$chr[i]),]
  
  dis <- min(abs(tfs$subnuc_peaks[i] - gs$xu_TSS)) 
  
  tfs$dis[i] <- dis
}


tfs$logratio <- log2(tfs$ratio +1)
tfs <- tfs[order(tfs$logratio,  decreasing = F),]

s1 <- sum(data[[1]])
s2 <- sum(data[[2]])

#normalizing matrices
matx.M <- (data.matrix(data[[2]][order(tfs$logratio,  decreasing = F),])* (s2/s2))
matx.N <- (data.matrix(data[[1]][order(tfs$logratio,  decreasing = F),])* (s2/s1))

#eliminating single reads to clean up background
matx.M[matx.M < 2] <- 0
matx.N[matx.N < 2] <- 0

#log2 ratio of reads 
mat_clus.M <- log2(matx.M+1) - log2(matx.N+1)

mat.M <- mat_clus.M[order(rowSums(mat_clus.M[,23:27]), decreasing = F),]
  

htm.m = matrix(c(0.05, 0.6, 0.1, 1, #(x1, x2, y1, y2)
                 0.6, 0.95, 0.1, 1,
                 0.05, 0.7, 0.08, 0.1, #xlab
                 0.02, 0.04, 0.15, 1), #ylab
               ncol = 4, byrow = T)



htm_plot.s = split.screen(htm.m)

screen(htm_plot.s[1])
par(mar = c(2,2,2,1)) 
dens_dot_plotB(mat.M, -1,1 , x_axt = "n")
axis(1, at=seq(-25, 25, length.out=3), labels=as.integer(seq(-250, 250, length.out=3)))

screen(htm_plot.s[2])
par(mar = c(4,0,4,6)) 

cl <- viridis(100, alpha = 1, begin = 0, end = 1, option = "C") 
ln=  cl[5]
int = "white"
hm=  cl[50]
#drawing color legend
my_palette <- colorRampPalette(c(ln,int,hm))(n = 99)
col_breaks = c(seq(-4.5, 4.5,length=100))      

image(1, seq(-4.5, 4.5,0.5), t(seq_along(seq(-4.5, 4.5,0.5))),ylab="",xlab="",
      axes=FALSE,
      col=my_palette, xaxt="n")
text(y = c(-4.5,-2.5,0, 2.5, 4.5), par("usr")[1], labels =c(-4.5,-2.5,0, 2.5, 4.5), 
     srt = 360, pos = 4, xpd = TRUE, cex=1, offset = 1.5)

text(y =c(-4.5,0,4.5), par("usr")[1], labels =c("Transient", "Fast","Slow"), 
     srt = 360, pos = 4, xpd = TRUE, cex=0.8, offset = 3, adj=0.5)

axis(4,at= c(-4.5,-2.5,0, 2.5, 4.5), labels = F, tick = -0.1)

screen(htm_plot.s[3])
par(mar=c(0,0,0,0))
mtext('Distance From TF Binding Site (bp)', side = 1, cex=1)

screen(htm_plot.s[4])
par(mar=c(0,0,0,0))
mtext('Factor Binding Sites', side = 2, cex=1)

