library(Rsamtools)
library(GenomicRanges)

source('/data/home/mpg22/scripts/create_typhoon_plot_functions_sacCer3genetablemodified_heatmap_colorchange.R')



t_tfs <- read.csv("~/MANUSCRIPT/temp_figs/figure_6new/tfs.csv", stringsAsFactors=F)

cl <- viridis(100, alpha = 1, begin = 0, end = 1, option = "D")
n=60
m=10
r=100
barp.m = matrix(c(0.05, 1, 0.1, 1, #(x1, x2, y1, y2)
                 0.05, 1, 0.08, 0.1, #xlab
                 0.02, 0.04, 0.15, 1), #ylab
               ncol = 4, byrow = T)

barp_plot.s = split.screen(barp.m)

screen(barp_plot.s[1])
par(mar = c(2,2,2,2)) # changing the margings 
x <- barplot(t(as.matrix(t_tfs[,2:4])), xaxt="n", main='', 
             col=c(cl[n], cl[m], "orange"), ylab= "")

#legend("topright" ,c("M > N", "N > M"," M == N"), col=c(cl[n], cl[m], cl[r]), 
 #      pch=c(19,19,19), 
  #     pt.cex=1,cex=1, bty = "n", h=F, y.intersp=3, x.intersp=1)


text(cex=0.5, x=x-1, y=-20.25, t_tfs[,1], xpd=TRUE, srt=45)

par(mar = c(2,2,2,2)) 
screen(barp_plot.s[2])
par(mar=c(0,0,0,0))
mtext('', side = 1, cex=1)

screen(barp_plot.s[3])
par(mar=c(0,0,0,0))
mtext('Total Sites', side = 2, cex=1)



