

data <- vector("list")
data[[1]] <- read.csv("~/Figure5/low1.csv")
data[[2]] <- read.csv("~/Figure5/low2.csv")
data[[3]] <- read.csv("~/Figure5/high1.csv")
data[[4]] <- read.csv("~/Figure5/high2.csv")
data[[5]] <- read.csv("~/Figure5/nochange1.csv")
data[[6]] <- read.csv("~/Figure5/nochange2.csv")

cl <- viridis(100, alpha = 1, begin = 0, end = 1, option = "C") #C
n=  5
int = "dark grey" 
m=  50

din.m = matrix(c(0.05, 1, 0.1, 1, #(x1, x2, y1, y2)
                 0.05, 1, 0.08, 0.1, #xlab
                 0.02, 0.04, 0.15, 1), #ylab
               ncol = 4, byrow = T)


din_plot.s = split.screen(din.m)

screen(din_plot.s[1])
par(mar = c(2,2,2,2)) # changing the margings 
plot(density(data[[5]][,1],bw=30), xlim=c(-500,500),main="", lty='dotted',
     col="grey", ylim=c(0.0007, 0.004), lwd=3)
lines(density(data[[6]][,1],bw=30), col= "grey", lwd=3)

lines(density(data[[3]][,1],bw=30), col= cl[m], lwd=3, lty='dotted')
lines(density(data[[4]][,1],bw=30), col= cl[m], lwd=3)

lines(density(data[[1]][,1],bw=30), col= cl[n], lwd=3, lty='dotted')
lines(density(data[[2]][,1],bw=30), col= cl[n], lwd=3)

screen(din_plot.s[2])
par(mar=c(0,0,0,0))
mtext('Distance From TF Binding Site (bp)', side = 1, cex=1)

screen(din_plot.s[3])
par(mar=c(0,0,0,0))
mtext('Factor Occupancy Profile', side = 2, cex=1)



