
chr_nuc_ratios.df <- read.csv("~/chr_nuc_ratios.csv", stringsAsFactors = F)

ss <- chr_nuc_ratios.df[which(log2(chr_nuc_ratios.df$Nreads) > 8 & log2(chr_nuc_ratios.df$Mreads) > 8),]
chr_nuc_ratios.df$Nnormreads <- (chr_nuc_ratios.df$Nreads)*(mean(ss$Mreads)/mean(ss$Nreads))

chr_nuc_ratios.df$ratio <- (chr_nuc_ratios.df$Mreads+1)/(chr_nuc_ratios.df$Nnormreads +1)

chr_nuc_ratios.df$htz1_zscore<-  as.numeric(scale(chr_nuc_ratios.df$htz1, center = T, scale=T))

######

origins.df  <- read.csv("~/oridb_acs_feature_file_jab-curated-798-sites_sacCer3.csv")
origins <- origins.df[(which(origins.df$footprint_class=='g1_and_g2_footprint')),]

for(i in 1:nrow(origins)){
  origins$start[i] <- origins$pos[i] - 500
  origins$end[i] <- origins$pos[i] + 500
  origins$rowname[i] <- i
}

chr_nuc_ratios.df$rowname <- rownames(chr_nuc_ratios.df)
ori.gr <- GRanges(seqnames= origins$chr, ranges = IRanges(start =origins$start,
                                                          end = origins$end), 
                  rowname = origins$rowname)

cn.gr <- GRanges(seqnames= chr_nuc_ratios.df$chr, ranges = IRanges(start =(chr_nuc_ratios.df$nuc_peaks),
                                                       width = 1),
                 rowname = chr_nuc_ratios.df$rowname)

ov.l <- as.data.frame(findOverlaps(ori.gr, cn.gr))

for(i in 1:nrow(origins)){
  idx <- which(ov.l[,1] == i)
  
  ss <- chr_nuc_ratios.df[ov.l[idx,2],]
  
  origins$mean_htz1[i] <- mean(ss$htz1)
  origins$median_htz1[i] <- median(ss$htz1)
  
  origins$mean_mat[i] <- mean(ss$Mnuc_mdpAv)
  origins$mean_nas[i] <- mean(ss$Nnuc_mdpAv)
  
  origins$median_mat[i] <- median(ss$Mnuc_mdpAv)
  origins$median_nas[i] <- median(ss$Nnuc_mdpAv)
}

or <- origins[order(origins$derived_origin_efficiency_from_mcguffee_et_al_2013, decreasing = T),]

H <- or[1:100,]  ###high efficiency
L <- or[(nrow(or)-99):nrow(or),]  ##low efficiency


unoHN <- H$mean_nas
unoLN <- L$mean_nas
unoHM <- H$mean_mat
unoLM <- L$mean_mat

  
box.m = matrix(c(0.05, 1, 0.1, 1 ,
                 0.02, 0.04, 0.1, 1 #left, right, bottom, top (x1, x2, y1, y2)
),
ncol = 4, byrow = T
)

box_plot.s = split.screen(box.m)

screen(box_plot.s[1])
par(mar = c(2,2.1,0,2.1), cex=1)
cln <- viridis(100, alpha = 1, begin = 0, end = 1, option = "D")
nas=25

cl <-cl <- brewer.pal(12, "Paired")
n=3
m=7

boxplot(unoHN, unoLN, unoHM, unoLM,notch=TRUE,outline=FALSE, na.omit= TRUE, ylab="Mean Nucleosome Midpoint Distance", 
        main="",
        names =c( "Active", "Passive", "Active", "Passive"), 
        col=c(cl[n],cl[m],cl[n],cl[m]), las=1, cex.main=1.5,cex.label=1, cex.axis=1,
        cex.lab=1.2,ylim=c(10,42.5))
mtext("Nascent", side=1, line=2, at=(1.5), cex=1.2)
mtext("Mature", side=1, line=2, at=(3.5), cex=1.2)

####ADDDING STATISTICS 
# capture x coordinates of bars
x <- c(1,2,3,4)
# set an offset for tick lengths
offset <- 1.5

# create the y coordinate of the line
y <- 33
# draw first horizontal line
lines(x[3:4],c(y, y), lwd=2)
# draw ticks
lines(x[c(3,3)],c(y, y-offset), lwd=2)
lines(x[c(4,4)],c(y, y-offset), lwd=2)
# draw asterics
text(x[3]+((x[4]-x[3])/2),y+offset,"n.s.", cex=1)

# create the y coordinate of the line
y <- 39
# draw first horizontal line
lines(x[1:2],c(y, y), lwd=2)
# draw ticks
lines(x[c(1,1)],c(y, y-offset), lwd=2)
lines(x[c(2,2)],c(y, y-offset), lwd=2)
# draw asterics
text(x[1]+((x[2]-x[1])/2),y+offset,"***", cex=2)

screen(box_plot.s[2])
par(mar=c(0,0,0,0))
mtext('Mean Positioning Score', side = 2, cex=1)


#Symbol Meaning
#ns P > 0.05
#* P ≤ 0.05
#** P ≤ 0.01
#*** P ≤ 0.001
#**** P ≤ 0.0001 (For the last two choices only)

