# Clear the workspace
graphics.off()
rm(list = ls())

##call functions
source('/figures/typhoon_plot_functions.R')

# Set the dir
subpanel_dir = "~/Figure3/"

tiff(file ="~/Figure3/Gutierrez_Fig3.tiff",height = 10, width = 13, units = "in", res = 300, compression = "lzw")

# Setup the screen
overall_scr.m = matrix(c(0, 0.5, 0.5,1,
                         0.5, 1 , 0.5, 1, #left, right, bottom, top (x1, x2, y1, y2)
                         0, 0.5, 0, 0.5,
                         0.5, 1, 0, 0.5,
                         
                         0, 0.03, 0.95, 1,
                         0.49, 0.52, 0.95, 1,
                         0, 0.03, 0.48, 0.51,
                         0.49, 0.52, 0.48, 0.51
),
ncol = 4, byrow = T
)

# Split the overall screen
close.screen(all.screens = T)

# Setup the screen
all_plots.s = split.screen(overall_scr.m)
par(oma = c(1, 1, 1, 1)) # make room (i.e. the 4's) for the overall x and y axis titles
#bottom, left, top, right

# Panel A:
cat("\tMaking plot A\n")
screen(all_plots.s[1])
par(mai=c(0,0,0,0))
source(paste(subpanel_dir, "positioing_score_density_3A.R", sep = ""))

# Panel B:
cat("\tMaking plot B\n")
screen(all_plots.s[2])
par(mai=c(0,0,0,0))

source(paste(subpanel_dir, "boxplot_3B.R", sep = ""))


# Panel C:
cat("\tMaking plot C\n")
screen(all_plots.s[3])
par(mai=c(0,0,0,0))
source(paste(subpanel_dir, "regression_boxplot_3D.R", sep = ""))

# Panel D:
cat("\tMaking plot D\n")

screen(all_plots.s[4])
par(mai=c(0,0,0,0))
source(paste(subpanel_dir, "occupancy_density_3C.R" , sep = ""))

# Add in the Figure Labels
screen(all_plots.s[5])
par(mai=c(0,0,0,0))
add_figure_label("A")

screen(all_plots.s[6])
par(mai=c(0,0,0,0))
add_figure_label("B")

screen(all_plots.s[7])
par(mai=c(0,0,0,0))
add_figure_label("C")

screen(all_plots.s[8])
par(mai=c(0,0,0,0))
add_figure_label("D")

mtext(expression(bold("Figure_3")), side =1, cex=1.5, outer=T, line = 0, adj = 0)

# Close all the screens
close.screen(all.screens = T)

# Close the device
dev.off()
