library(viridis)
library(RColorBrewer)

#subset quintiles (see script ACF_boxplot_2D.R)
q.l <- vector("list")
q.l[[1]] <- zg_subset[which(zg_subset$N_M_corr < q[2]),]
q.l[[2]] <- zg_subset[which(zg_subset$N_M_corr > q[2] & zg_subset$N_M_corr < q[3]),]
q.l[[3]] <- zg_subset[which(zg_subset$N_M_corr > q[3] & zg_subset$N_M_corr < q[4]),]
q.l[[4]] <- zg_subset[which(zg_subset$N_M_corr > q[4] & zg_subset$N_M_corr < q[5]),]
q.l[[5]] <- zg_subset[which(zg_subset$N_M_corr > q[5]),]


q.m <- matrix(0, ncol=27, nrow=5)
cls <- colnames(zg_subset[c(32:57,60)])

#calculate the mean of the Z-scores for each variant at each gene 
for(i in 1:27){
  for(c in 1:5){
    q.m[c,i] <- mean(q.l[[c]][,cls[i]]) 
  }
}


#convert first letter to upper case
firstup <- function(x) {
  substr(x, 1, 1) <- toupper(substr(x, 1, 1))
  x
}
thirdup <- function(x) {
  substr(x, 3, 3) <- toupper(substr(x, 3, 3))
  x
}
fourthup <- function(x) {
  substr(x, 4, 4) <- toupper(substr(x, 4, 4))
  x
}

cls <- firstup(cls)
cls<- thirdup(cls)
cls <- fourthup(cls)
#convert all letters of interest to upper case, will have to individually change the others that shouldnt change
cls <-  chartr(old = "t", new = "T", cls)

colnames(q.m) <- cls

#ht <- heatmap(t(q.m),Colv = NA, cexRow = 0.8,   margins = c(1, 12))

#write.csv(ht$rowInd, "~/Figure2/htmp_rowInd2.csv", row.names = F)

Ind <- read.csv("~/Figure2/htmp_rowInd2.csv", stringsAsFactors=F)

ht.m = matrix(c(0.05, 0.8, 0.1, 1,
                0.05, 1, 0, 0.05, #xlab
                0.8, 1, 0.1, 1), #ylab
              ncol = 4, byrow = T)

ht_plot.s = split.screen(ht.m)

screen(ht_plot.s[1])
par(mar=c(2,4,2,0))
mm <- (q.m[,Ind[,1]])
mm <-  (q.m[,ht$rowInd])
my_palette <- colorRampPalette(c("blue","white","red"))(n = 99)
col_breaks = c(seq(-0.9,0.9,length=100))      

image(mm, col=my_palette,breaks=col_breaks ,  axes=FALSE, bty="n")
axis(1, at=seq(0,1,0.25), labels=c(1,2,3,4,5), tick = 0)
text(y = seq(0,1,(1/26)), par("usr")[1], labels = colnames(mm), 
     srt = 360, pos = 2, xpd = TRUE, cex=0.7)

mtext('Quintiles', side = 1, cex=1, line= 2 ,  at=(0.48))

screen(ht_plot.s[2])
par(mar=c(0,0,0,0.5))
mtext("Slow", side =1, cex=1, outer=F, line = -1, adj = 0.2)
mtext("Fast", side =1, cex=1, outer=F, line = -1, adj = 0.75)

screen(ht_plot.s[3])
par(mar = c(5,0.5,5,3.5)) #  left, top, and right.

# Draw the color legend
image(1, seq(-0.9,0.9,.10), t(seq_along(seq(-0.9,0.9,.10))),ylab="",xlab="",
      axes=FALSE,
      col=my_palette, xaxt="n")

text(y = seq(-0.75,0.75,(1/2)), par("usr")[1], labels = seq(-0.75,0.75,(1/2)), 
     srt = 360, pos = 4, xpd = TRUE, cex=0.7, offset = 2, 
     adj = 0.5)

text(y = -.25, par("usr")[1], labels ="Mean Z-score", 
     srt = 90, pos = 4, xpd = TRUE, cex=0.7, offset = 3.7)

axis(4,at= seq(-0.75,0.75,(2/4)), labels = F, tick = 0.3, lwd.ticks=1)


#https://rlbarter.github.io/superheat/heatmap-colormap.html