library(viridis)
library(RColorBrewer)

genes <- genes[-(which(genes$length < 400)),]
genes$NET_seq <- as.numeric(log2(genes$NET_seq+1))
zg <- genes

file_name <- colnames(zg[c(32:57,60)])

for(i in 1:length(file_name)){
  zg[,file_name[i]] <-  as.numeric(scale(genes[,file_name[i]], center = T, scale=T))
}

zg_subset <- zg[which(zg$acf_M > median(zg$acf_M, na.rm=T)),]

q <- quantile(zg_subset$N_M_corr, seq(0,1,.20))
q1 <- zg_subset[which(zg_subset$N_M_corr < q[2]),] # first quintile/slow
q2 <- zg_subset[which(zg_subset$N_M_corr > q[5]),] # fifth quintile/fast

#set the color scheme 
cl <- viridis(100, alpha = 1, begin = 0, end = 1, option = "D")
n=90
m=45

bp.m = matrix(c(0.05, 1, 0.15, 1,
                 0.05, 1, 0, 0.15, #xlab
                 0.02, 0.04, 0.1, 1), #ylab
               ncol = 4, byrow = T)


bp_plot.s = split.screen(bp.m)

screen(bp_plot.s[1])
par(mar = c(2,2.1,2,2.1), cex=1)

boxplot(q1[,"acf_N"], q2[,"acf_N"], q1[,"acf_M"], q2[,"acf_M"], ylim=c(-0.5, 1),
        main=" ",outline=F, notch=T,
        names = c("Nascent","Nascent", "Mature", "Mature"),
        col=c(cl[n], cl[m], cl[n],cl[m]))

####ADDDING STATISTICS 
# capture x coordinates of bars
x <- c(1,2,3,4)
# create the y coordinate of the line
y <- 0.9
# set an offset for tick lengths
offset <- 0.05
# draw first horizontal line
lines(x[1:2],c(y, y), lwd=2)
# draw ticks
lines(x[c(1,1)],c(y, y-offset), lwd=2)
lines(x[c(2,2)],c(y, y-offset), lwd=2)
# draw asterics
text(x[1]+((x[2]-x[1])/2),y+offset,"****", cex=1.5)


# create the y coordinate of the line
y <- 0.85
# draw first horizontal line
lines(x[3:4],c(y, y), lwd=2)
# draw ticks
lines(x[c(3,3)],c(y, y-offset), lwd=2)
lines(x[c(4,4)],c(y, y-offset), lwd=2)
# draw asterics
text(x[3]+((x[4]-x[3])/2),y+offset,"n.s.", cex=1)


#Symbol Meaning
#ns P > 0.05
#* P ≤ 0.05
#** P ≤ 0.01
#*** P ≤ 0.001
#**** P ≤ 0.0001 (For the last two choices only)

screen(bp_plot.s[2])
par(mar=c(0,0,0,0))
plot(0, 0, type = "n", bty = "n", xaxt = "n", yaxt = "n")
legend(-0.25, 0.5, legend = c("Slow", "Fast"), h=T,
       col=c("black", "black"), pch=c(21, 21), pt.bg=c(cl[n], cl[m]),
       bty = "n", cex= 0.9, pt.cex= 1.5)

screen(bp_plot.s[3])
par(mar=c(0,0,0,0))
mtext('ACF', side = 2, cex=1)

