##### Samtools sequencing data processing ####
#/usr/local/bin/R

library(Rsamtools)
library(GenomicRanges)

##call functions
source('/figures/typhoon_plot_functions.R')

#setting up parameters
origin_name = "early"
chr = "chrIV"

new_start= 435164 - 6000 
new_end= 435164 + 6000  


#define the read boudaries (nucleosomal and/or subnucleosomal)
length_min = 20
length_max = 250

#make matrix, a column for each fragment read length                       
matx.m = matrix(0, nrow=250, ncol=(new_end-new_start)+1)

chr.gr = GRanges(seqnames= chr, ranges = IRanges(start =new_start , end = new_end ))

p = ScanBamParam(what = c("rname", "strand", "pos", "isize"),which = chr.gr)

#data files
file_name.bam = "DM719_sacCer3_M1_2016-10-26-13-30.bam"
file_name.bam.bai = "DM719_sacCer3_M1_2016-10-26-13-30.bam.bai"

A_reads.l = scanBam(file = file_name.bam,
                    index = file_name.bam.bai,
                    param = p)

#All the information from the range is in the first entry of the output_reads.l list 
# str(output_reads.l[[1]]) to see list structure

#create a new GenomicRanges object for the reads from this list:
A_reads.gr = GRanges(seqnames = A_reads.l[[1]]$rname,
                     ranges = IRanges(start = A_reads.l[[1]]$pos,
                                      width = A_reads.l[[1]]$isize))

#defyning bp coverage.
mat.gr = GRanges(seqnames = chr, ranges = IRanges(start=new_start:new_end,width=1))

for(i in 20:250){
  subset_data.gr = A_reads.gr[which(width(A_reads.gr)==i)]
  
  start(subset_data.gr) = start(subset_data.gr) + width(subset_data.gr)/4
  end(subset_data.gr) = end(subset_data.gr) - width(subset_data.gr)/4
  
  matx.m[i,]=countOverlaps(mat.gr, subset_data.gr) 
}

#making the plot
cat("Creating the plot...\n")
library(gplots)

scr.m = matrix(c(0.05, 1, 0.85, 1, ##left, right, bottom, top (x1, x2, y1, y2)
                 0.05, 1, 0.75, 0.85,
                 0.05, 1, 0.1, 0.75,
                  
                 0.05, 1, 0, 0.015, #xlab
                 0.04, 0.05, 0.1, 0.90), #ylab
               ncol = 4, byrow = T
)

my_plot.s = split.screen(scr.m)

zm=25
screen(my_plot.s[1])
par(mar = c(0,2.1,0,2.1), cex=0.7)
make_gene_schematic(chr, new_start, new_end, proteinCoding = F,y_low = 0, y_high = 1.05)

screen(my_plot.s[2])
par(mar = c(0,2.1,0,2.1), cex=0.7)  
make_ars_schematic(chr, new_start, new_end)

screen(my_plot.s[3])
par(mar = c(1,2.1,1,2.1), cex=1, cex.main=1)
dens_dot_plot( matx.m, z_min = 0, z_max = zm, plot_title='', x_axt = "n")
axis(side=1, at= seq(new_start, new_end, 1000), labels= seq(new_start/1000, new_end/1000, 1), tck= -0.05)

screen(my_plot.s[4])
par(mar=c(0,0,0,0))
mtext('ChrIV Position (Kb)', side = 1, cex=1)

screen(my_plot.s[5])
par(mar=c(0,0,0,0))
mtext('Fragment Length (bp)', side = 2, cex=1)

cat("\tComplete!\n")
