#/usr/local/bin/R

library(Rsamtools)
library(GenomicRanges)

# call in origin data frame
origins <- read.csv("~/data_frames/oridb_acs_feature_file_jab-curated-798-sites_sacCer3.csv")
origins <- origins[which(origins$footprint_class != "no_footprint"),]
chrIV <- origins[which(origins$chr == "chrIV"),]
early <- chrIV[which(chrIV$activation_time == "early"),]

# set up coordinates for coverage 
  chr = "chrIV"
  
  #chromosome lentgh (start and end) for genomic ranges
  new_start= 1
  new_end= 1531933 
  
  chr.gr = GRanges(seqnames= chr, ranges = IRanges(start =new_start , end = new_end ))
  
  p = ScanBamParam(what = c("rname", "strand", "pos", "isize"),which = chr.gr)

    
    #data files
    file_name.bam = "DM719_sacCer3_M1_2016-10-26-13-30.bam"
    file_name.bam.bai = "DM719_sacCer3_M1_2016-10-26-13-30.bam.bai"
    
    A_reads.l = scanBam(file = file_name.bam, 
                        index = file_name.bam.bai,
                        param = p)                             
    
    #All the information from the range is in the first entry of the output_reads.l list 
    # str(output_reads.l[[1]]) to see list structure
    
    #create a new GenomicRanges object for the reads from this list:
    A_reads.gr = GRanges(seqnames = A_reads.l[[1]]$rname,
                         ranges = IRanges(start = A_reads.l[[1]]$pos, 
                                          width = A_reads.l[[1]]$isize))
    
    #looking at GRanges objects with the coverage method. 
    
    cov <- coverage(A_reads.gr)
    rpts.v <- rep(runValue(cov[[chr]]),runLength(cov[[chr]])) # repeats. 
 
  cov_1 <- rpts.v
  

  # Make the nucleosome profile
  par(mar = c(1,2.1,1,2.1), cex=1, cex.main=1)
  plot(cov_1, ylim= c(0,7000), type="h", lwd=1, bty="n",
       col="blue",xlab="", xaxt='n', yaxt='n',ylab="") 
  axis(1, at=seq(1, new_end - new_start, length.out=10), 
       labels=as.integer(seq(new_start/1000, new_end/1000, length.out=10)))
  axis(2, at=seq(0, 12711, length.out=10), 
       labels=NA , tick = 0.5)
  abline(v=early$pos, col=alpha("dark green",0.15), lwd=15)
  
   mtext('Coverage', side = 2, outer = F, cex=1, line = 2)
   
 
