#Go through a bed file (for example of called peaks) and print a bunch of observations in the sequencing data about a given entry

use List::Util 'max';
use Data::Dumper qw(Dumper);

use List::Util 'max';
use List::Util 'sum';
use Statistics::Basic qw(:all);
use Data::Dumper qw(Dumper);
use Statistics::Distributions;
use Statistics::TTest;


foreach $parameter( @ARGV )
{
	if( substr($parameter,0,1) eq '-')
	{
		($pname, $pval) = split( '=',substr($parameter,1)) ;
		if ($pval eq '') { $pval = 1; }
		$PARAMS{$pname} = $pval;
	}
		
}

$bedfile = $PARAMS{bed} if $PARAMS{bed};
$icshape_bigwig = "/Users/DarthRNA/Documents/Frisco/icshape_aug16/GSE60034_v65polyA+icSHAPE_NAI-N3_vivo.bw";


open(BED, $bedfile);
while(<BED>)
{
	chomp;

	my ($chr, $start, $end, $name, $score, $strand) = split('	');
	my $width = abs($end-$start)+1;
	my $icshape = 0;
	my $ichsape_std = 0;
	my $icshape_folddif = 0;
	my $icshape_nfolded = 0;
	#bigWigSummary /Users/DarthRNA/Documents/Frisco/icshape_aug16/GSE60034_v65polyA+icSHAPE_NAI-N3_vivo.bw chr10 80900075 80900145 71
	open(BW,"bigWigSummary $icshape_bigwig $chr $start $end 70|") || die;
	my $outputstring = '';
	while(<BW>)
	{
		chomp;
		$outputstring .= $_;
	}
	close BW;
	next unless $outputstring ne '' && $width != 0;

	my @bigwig = split("\t",$outputstring);
	
	next unless scalar(@bigwig) == 70;

	print "$name\t";

	print join("\t", @bigwig) . "\n";

}

close(BED);
