use List::Util 'max';
use List::Util 'min';
use List::Util 'sum';
use Statistics::Basic qw(:all);
use Data::Dumper qw(Dumper);
use Math::NumberCruncher;
use Statistics::Distributions;

foreach $parameter( @ARGV )
{
	if( substr($parameter,0,1) eq '-')
	{
		($pname, $pval) = split( '=',substr($parameter,1)) ;
		if ($pval eq '') { $pval = 1; }
		$PARAMS{$pname} = $pval;
	}
		
}

my $ifile = $PARAMS{in};
my $ofile = $PARAMS{out};

open (IN, $ifile);
open (OUT, ">$ofile");

#my $header = <IN>;
#chomp;

print OUT "Peakname\tPhyloP\tAbs_PhyloP\tAbsPhyloP_minus_PhyloP\n";

while(my $line = <IN>)
{
	chomp $line;
	my (undef, undef, undef, $rname, undef) = split("\t",$line);
	my ($class, $name, $loc, $number) = split('_',$rname);
	next if !$loc && $PARAMS{genomic};
	my ($chr,$rest) = split(':',$loc);
	my ($start,$end) = split('-',$rest);
	my ($phy, $abs_phy) = (0,0);
	my ($try_phy, $try_abs_phy) = getRegionPhyloP($chr,$start,$end) if $loc;

	$phy = $try_phy if $try_phy;
	$abs_phy = $try_abs_phy if $try_abs_phy;
	my $dif = $abs_phy - $phy;
	print OUT "$rname\t$phy\t$abs_phy\t$dif\n";
	
}

close OUT;
close IN;



sub getRegionPhyloP
{
	my ($chr,$start,$end) = @_;
	my $width = abs($end-$start)+1;
	my $phyloP_bigwig = "/Users/DarthRNA/Documents/Adam/genomes/mm10.60way.phyloP60wayPlacental.bw";

	open(BW,"bigWigSummary $phyloP_bigwig $chr $start $end $width|") || die;

	my $outputstring = '';
	
	while(<BW>)
	{
		chomp;
		$outputstring .= $_;
	}

	close BW;

	return 0 unless $outputstring ne '' && $width != 0;

	my @bigwig = split("\t",$outputstring);
	my $sum = 0;
	my $abssum = 0;

	for $i(0..$width-1)
	{
		$sum += $bigwig[$i];
		$abssum += abs($bigwig[$i]);
	}

	return ($sum / $width, $abssum / $width) if $width;
	return;
}
