#merge count data for diff analysis 


#merge genes and orf 
count_genes=read.table("../../13_TE_Cer/04_coverage_start/S288C_Genes_start60.count")
count_orf=read.table("../../13_TE_Cer/04_coverage_start/S288Corf_scer_genomic_start60.count")

#add significants

count_genes$name=rep(NA,dim(count_genes)[1])
#add gene names
for (i in 1:dim(count_genes)[1]){
	gene_names=count_genes$V9[i]
	count_genes$name[i]=unlist(strsplit(as.character(gene_names),";"))[1]
}

data_genes=data.frame(name=sub("ID=","",count_genes$name), RPF1=count_genes$V10, RPF2=count_genes$V11,
TOT1=count_genes$V12, TOT2=count_genes$V13, type=rep("gene", dim(count_genes)[1]))

#idem for orf
count_orf$name=rep(NA,dim(count_orf)[1])
for (i in 1:dim(count_orf)[1]){
	orf_names=count_orf$V9[i]
	count_orf$name[i]=unlist(strsplit(as.character(orf_names),";"))[1]
}

data_orf=data.frame(name=sub("name=","",count_orf$name), RPF1=count_orf$V10, RPF2=count_orf$V11,
TOT1=count_orf$V12, TOT2=count_orf$V13, type=rep("orf", dim(count_orf)[1]))


#write genes and orf in one file 

data_all=rbind(data_genes, data_orf)
#extract significants orfs#############################################################
data_stat=read.table("../../13_TE_Cer/03_annotations/table_all_stat.txt", header=T)
sig_names=unique(data_stat$name[data_stat$sig=="1" ])
stat_red=data_stat[,c(3,14)]


data_all2=merge(data_all, stat_red, by.x="name", by.y="name",all.x=T)
write.table(data_all2,"../../13_TE_Cer/04_coverage_start/countall_start60.txt", sep="\t", quote=F )

