
ccol=c("grey22","grey22","springgreen3", "#e600e6")


#read table
data=read.table("data/colony-size-data-timepoint-60-glucose-181129.txt",header=T)
#remove border and empty 
data=data[data$id != "Border",]
data=data[data$id != "0",]

data$frame=matrix(unlist(strsplit(as.character(data$id),"_")),ncol=3, byrow=T)[,2]
data$cond=paste(data$run, ";",data$frame, sep="")

#take list of orf or gen names
corf=unique(data$orf)
orft=NULL
cbiz=c("220388","230326","23483","80553","15907","102655","70680","210904","153359")

pdf("figures/barplot_in_out_sig_log.pdf",width=7, height=8)
par(mar=c(5,4,2,1), mfrow=c(4,5))
for (i in 1:length(corf)){
orfi=as.character(corf[i])
if (orfi %in% cbiz==F){
	datai=data[data$orf==corf[i],]
	cnames=c("in_cont","out_cont","in_MTX","out_MTX")
	#check if constructions
	count_all=table(datai$strain, datai$cond)
	count_clean=count_all[apply(count_all,1,sum) != 0,]
	selhaplo=row.names(count_clean)
	
	for (haploi in selhaplo){
		dataih=datai[datai$strain ==haploi,]
		dataih$sepcol=paste(dataih$id, "_",dataih$run,sep="")
		dataih=dataih[order(dataih$cond),]
		#select medium 
		list_cond=unique(datai$cond)
		if (length(unique(dataih$cond))==4){
			#tlabel=matrix(unlist(strsplit(dataih$sepcol, "_")),ncol=4,byrow=T)
			
			# tests
			#check diff between controls
			#cont1=dataih$size[dataih$cond=="glu-con-2;in"]	
			#cont2=dataih$size[dataih$cond=="glu-con-2;out"]	
		
			cont1=dataih$size[dataih$cond=="glu-mtx-2;in"]	
			cont2=dataih$size[dataih$cond=="glu-mtx-2;out"]	
			pvalg=t.test(log2(cont1+1),log2(cont2+1))$p.value
		
			labg=""
			if (pvalg <= 0.001){
				labg="***" 
			}
			if (pvalg <=0.01 & pvalg > 0.001){
				labg="**" 
			}
			if (pvalg <=0.05 & pvalg > 0.01){
				labg="*" 
			}
		
			if (labg != ""){
				orft=c(orft,as.character(orfi))
				plot(as.factor(dataih$cond),dataih$size+1,border=ccol,names=c("","","",""),log="y",ylab="Colony sizes (log2)")
				mtext(cnames, side = 1, line=1,outer = F, at = 1:4, las=2,cex=0.6)
		title(paste("Sp",haploi,"; tORF_",corf[i],"\n",labg,sep="" ),cex.main=1)
			
			}
		}
	}
}}
dev.off()

#NOt sig 

#take list of orf or gen names
corf=unique(data$orf)
orft=NULL
cbiz=c("220388","230326","23483","80553","15907","102655","70680","210904","153359")

pdf("figures/barplot_in_out_notsiglog.pdf",width=7, height=8)
par(mar=c(5,4,2,1), mfrow=c(4,5))
for (i in 1:length(corf)){
orfi=as.character(corf[i])
if (orfi %in% cbiz==F){
	datai=data[data$orf==corf[i],]
	cnames=c("in_cont","out_cont","in_MTX","out_MTX")
	#check if constructions
	count_all=table(datai$strain, datai$cond)
	count_clean=count_all[apply(count_all,1,sum) != 0,]
	selhaplo=row.names(count_clean)
	
	for (haploi in selhaplo){
		dataih=datai[datai$strain ==haploi,]
		dataih$sepcol=paste(dataih$id, "_",dataih$run,sep="")
		dataih=dataih[order(dataih$cond),]
		#select medium 
		list_cond=unique(datai$cond)
		if (length(unique(dataih$cond))==4){
			#tlabel=matrix(unlist(strsplit(dataih$sepcol, "_")),ncol=4,byrow=T)
			
			# tests
			#check diff between controls
			#cont1=dataih$size[dataih$cond=="glu-con-2;in"]	
			#cont2=dataih$size[dataih$cond=="glu-con-2;out"]	
		
			cont1=log2(dataih$size[dataih$cond=="glu-mtx-2;in"]+1)
			cont2=log2(dataih$size[dataih$cond=="glu-mtx-2;out"]+1)
			pvalg=t.test(cont1,cont2)$p.value
		
			labg=""
			if (pvalg <= 0.001){
				labg="***" 
			}
			if (pvalg <=0.01 & pvalg > 0.001){
				labg="**" 
			}
			if (pvalg <=0.05 & pvalg > 0.01){
				labg="*" 
			}
		
			if (labg == ""){
				orft=c(orft,as.character(orfi))
				plot(as.factor(dataih$cond),dataih$size+1,log="y",border=ccol,names=c("","","",""),ylab="Colony sizes (log2)")
				mtext(cnames, side = 1, line=1,outer = F, at = 1:4, las=2,cex=0.6)
		title(paste("Sp",haploi,"; tORF_",corf[i],"\n",labg,sep="" ),cex.main=1)
			
			}
		}
	}
}}
dev.off()


#Nbizarres

#take list of orf or gen names
corf=unique(data$orf)
orft=NULL
cbiz=c("220388","230326","23483","80553","15907","102655","70680","210904","153359")

pdf("figures/barplot_in_out_weird.pdf",width=7, height=8)
par(mar=c(5,4,2,1), mfrow=c(4,5))
for (i in 1:length(corf)){
orfi=as.character(corf[i])
if (orfi %in% cbiz==T){
	datai=data[data$orf==corf[i],]
	cnames=c("in_cont","out_cont","in_MTX","out_MTX")
	#check if constructions
	count_all=table(datai$strain, datai$cond)
	count_clean=count_all[apply(count_all,1,sum) != 0,]
	selhaplo=row.names(count_clean)
	
	for (haploi in selhaplo){
		dataih=datai[datai$strain ==haploi,]
		dataih$sepcol=paste(dataih$id, "_",dataih$run,sep="")
		dataih=dataih[order(dataih$cond),]
		#select medium 
		list_cond=unique(datai$cond)
		if (length(unique(dataih$cond))==4){
			#tlabel=matrix(unlist(strsplit(dataih$sepcol, "_")),ncol=4,byrow=T)
			
			# tests
			#check diff between controls
			#cont1=dataih$size[dataih$cond=="glu-con-2;in"]	
			#cont2=dataih$size[dataih$cond=="glu-con-2;out"]	
		
			cont1=log2(dataih$size[dataih$cond=="glu-mtx-2;in"]	+1)
			cont2=log2(dataih$size[dataih$cond=="glu-mtx-2;out"]+1)
			pvalg=t.test(cont1,cont2)$p.value
		
			labg=""
			if (pvalg <= 0.001){
				labg="***" 
			}
			if (pvalg <=0.01 & pvalg > 0.001){
				labg="**" 
			}
			if (pvalg <=0.05 & pvalg > 0.01){
				labg="*" 
			}
		
			if (labg != ""){
				orft=c(orft,as.character(orft))
				plot(as.factor(dataih$cond),dataih$size+1,border=ccol,log="y",names=c("","","",""),ylab="Colony sizes (log2)")
				mtext(cnames, side = 1, line=1,outer = F, at = 1:4, las=2,cex=0.6)
		title(paste("Sp",haploi,"; tORF_",corf[i],"\n(",labg,")",sep="" ),cex.main=1)
			
			}
		}
	}
}}
dev.off()


