#!/usr/bin/env python

#script to run the multicov command from bedtools : 
#to extract read coverage per gene or orf 
import os

#liste contains orf and genes files with bam correspondances

#run with st1 or st0 orf and conserved genes 
liste="corres_reads.txt"
dir_out="../../05diff_exp/02_read_counts_full/"

with open(liste) as corres:
    for line in corres:
        line=line.rstrip()
        if line.startswith("#") is False:
            array=line.split(" ")
            gff=array[0]
            #RPF
            seq1=" ".join([array[1],array[2]])
            fileout1=dir_out+gff.split("/")[-1].replace("gff", "rpfcount")
            cmd1="bedtools multicov -bams "+seq1+" -bed "+gff+" -D -s > "+fileout1
            print cmd1
            os.system(cmd1)
            
            #tot
            seq2=" ".join([array[3], array[4]])
            fileout2=dir_out+gff.split("/")[-1].replace("gff", "totcount")
            cmd2="bedtools multicov -bams "+seq2+" -bed "+gff+" -D -s > "+fileout2
            print cmd2
            os.system(cmd2)

