import os

dir_gtf="../../04plastid/01_gtf_files/"
dir_res="../../04plastid/02_metagene_results/"
dir_bam="../../../../04analyses_RPF/02mapping_ps/merged_rep_plastid/"

dico_bam={\
"SA03": dir_bam+"RPF_CConA03_ps_sorted.bam", \
"SD01": dir_bam+"RPF_AAallonD01_ps_sorted.bam", \
"SD06": dir_bam+"RPF_BBallonD06_ps_sorted.bam ", \
"Y128" : dir_bam+"RPF_CerallonYPS128_ps_sorted.bam", \
}


chaplo=["SA03","SD06", "SD01", "Y128"]


for haplo in chaplo:
	# generate a file of region of interest
	cmd="metagene generate "+dir_res+haplo+"_sORF "+\
	"--landmark cds_start "+\
	"--annotation_files "+dir_gtf+haplo+"_ORF.gtf" 
	
	print cmd
	os.system(cmd)
	
	
	#metagene analysis with best length
	#Here we use a variable psite offset estimated with genes by the psite script
	
	cmd="metagene count "+dir_res+haplo+"_sORF_rois.txt "+dir_res+haplo+"_metagenes_sORF "+\
	"--count_files "+dico_bam[haplo]+" "+\
	"--fiveprime_variable --offset "+dir_res+haplo+"_RPF_genes_p_offsets.txt "+\
	"--normalize_over 30 100 "+\
	"--min_counts 20 --cmap Blues --title \"Metagene_sORF_"+haplo+"\""
	print cmd
	os.system(cmd)
	
	#Metagene plot 
	cmd="metagene chart "+dir_res+haplo+"_riboprofile_sORF_chart.png "+\
	dir_res+haplo+"_metagenes_sORF_metagene_profile.txt "+ \
	"--landmark \"start codon\" "+\
	"--title \"Metagene sORF "+haplo+"\""
	
	print cmd 
	os.system(cmd)
	
	
	#density per transcript 
	
	cmd="get_count_vectors --annotation_files "+dir_gtf+haplo+"_ORF.gtf "+\
	"--annotation_format GTF2 "+\
	"--count_files "+dico_bam[haplo]+" "+ \
	"--fiveprime_variable --offset "+dir_res+haplo+"_RPF_genes_p_offsets.txt "+ \
	dir_res+haplo+"_density_per_orf"
	
	print cmd 
	os.system(cmd)
