#Parse gff to gtf file for metagene analysis with plastid package
#write 3 lines per orf: 
#- exon with UTR
#-CDS
#start position 


def gff_to_gtf(gff, gtf, minsize):
    upstream=50
    downstream=102
    with open(gtf, "w")as out:
        with open(gff)as gff:
            for line in gff:
                line=line.rstrip()
                array=line.split("\t")
                info=array[-1].split(";")[0].replace("id_orf=","")
                newinfo="gene_id \""+info+"\"; transcript_id \""+info+\
                "\"; start_codon \"ATG\";"
                size=int(array[4])-int(array[3])+1
                if int(array[3])>110 and size > minsize:
                    #SENS FORWARD
                    #===================================================
                    if array[6]=="+":
                        #exon line
                        #print line
                        exonarray=line.split("\t")
                        exonarray[2]="exon"
                        exonarray[3]=str(int(array[3])-upstream)
                        exonarray[4]=str(int(array[4])+downstream)
                        exonarray[-1]=newinfo
                        exon_line="\t".join(exonarray)+"\n"
                        out.write(exon_line)
                        
                        #CDS line
                        CDSarray=line.split("\t")
                        CDSarray[-1]=newinfo
                        CDSarray[2]="CDS"
                        CDS_line="\t".join(CDSarray)+"\n"
                        out.write(CDS_line)
                        
                        #start_codon
                        startarray=line.split("\t")
                        endcount=int(CDSarray[4])-int(CDSarray[3])+1+upstream
                        
                        infostart=newinfo+" cds_start \"50\"; cds_end \""+\
                        str(endcount)+"\";" 
                        startarray[-1]=infostart
                        startarray[2]="start_codon"
                        startarray[4]=str(int(array[3])+2)
                        start_line="\t".join(startarray)+"\n"
                        out.write(start_line)
                        
                    
                    #SENS REVERSE 
                    #====================================================
                    if array[6]=="-":
                        #exon line
                        #print line
                        exonarray=line.split("\t")
                        exonarray[2]="exon"
                        exonarray[3]=str(int(array[3])-downstream)
                        exonarray[4]=str(int(array[4])+upstream)
                        exonarray[-1]=newinfo
                        exon_line="\t".join(exonarray)+"\n"
                        out.write(exon_line)
                        
                        #CDS line
                        CDSarray=line.split("\t")
                        CDSarray[-1]=newinfo
                        CDSarray[2]="CDS"
                        CDS_line="\t".join(CDSarray)+"\n"
                        out.write(CDS_line)
                        
                        #start_codon line
                        startarray=line.split("\t")
                        endcount=int(CDSarray[4])-int(CDSarray[3])+3+upstream
                        
                        infostart=newinfo+" cds_start \"50\"; cds_end \""+\
                        str(endcount)+"\";" 
                        startarray[-1]=infostart
                        startarray[2]="start_codon"
                        startarray[3]=str(int(array[4])-2)
                        start_line="\t".join(startarray)+"\n"
                        out.write(start_line)

# ANALYSIS #############################################################
#directories for gff or gtf files
gff_dir="../../03synt_intergenic_orf/03_ORF_cons_spar/03per_haplo_stat1_ps/"
gtf_dir="../../04plastid/01_gtf_files/"
minsize=60

#list of haplotypes to parse
chaplo=["SA03", "SD01", "SD06", "Y128"]

for haplo in chaplo:
    gff_file="table_orf_"+haplo+"_stat1.gff"
    gtf_file=haplo+"_ORF.gtf"
    gff_to_gtf(gff_dir+gff_file, gtf_dir+gtf_file, minsize)


